package com.kontakt.sdk.android.ble.filter.ibeacon;

import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconAdvertisingPacket;
import com.kontakt.sdk.android.common.util.IBeaconPropertyValidator;

/**
 * Predicate accepting iBeacon's advertising packet with specific major value.
 */
public final class MajorFilter implements IBeaconFilter {

  private final int major;

  public MajorFilter(final int major) {
    IBeaconPropertyValidator.validateMajor(major);
    this.major = major;
  }

  @Override
  public boolean apply(IBeaconAdvertisingPacket target) {
    return major == target.getMajor();
  }

  /**
   * Provides major.
   *
   * @return the major
   */
  public int getMajor() {
    return major;
  }
}
