package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.ble.spec.Telemetry;
import com.kontakt.sdk.android.common.util.ConversionUtils;

final class TLMResolver implements EddystonePropertyResolver<Telemetry> {

    static final int TLM_START_INDEX = 12;
    private static final int SCAN_RECORD_TLM_LENGTH = 13;

    @Override
    public byte[] extract(byte[] scanRecord) {
        return ConversionUtils.extractPayload(
                scanRecord,
                TLM_START_INDEX,
                SCAN_RECORD_TLM_LENGTH
        );
    }

    @Override
    public Telemetry parse(byte[] source) {
        if (source == null) {
            return null;
        }

        final int version = source[0] & 0x00FF;

        final byte[] batteryVoltage = new byte[]{
                source[1],
                source[2]
        };

        final int batteryVoltageValue = ConversionUtils.asInt(batteryVoltage);

        final byte[] tempVoltage = new byte[]{
                source[3],
                source[4]
        };

        final double tempVoltageValue = (ConversionUtils.asInt(tempVoltage) * 1.0) / 256;


        final byte[] advertisingPduCount = new byte[] {
                source[5],
                source[6],
                source[7],
                source[8]
        };

        final int advertisingPduCountValue = ConversionUtils.asInt(advertisingPduCount);

        final byte[] timeSincePowerUp = new byte[] {
                source[9],
                source[10],
                source[11],
                source[12]
        };

        final int timeSincePowerUpValue = ConversionUtils.asInt(timeSincePowerUp) / 10;

        return new Telemetry.Builder()
                .setBatteryVoltage(batteryVoltageValue)
                .setTemperature(tempVoltageValue)
                .setTimeSincePowerUp(timeSincePowerUpValue)
                .setPduCount(advertisingPduCountValue)
                .setVersion(version)
                .build();
    }
}
