package com.kontakt.sdk.android.ble.discovery.eddystone;

import com.kontakt.sdk.android.common.util.ConversionUtils;

final class InstanceIdResolver implements EddystonePropertyResolver<String> {

    static final int INSTANCE_ID_START_INDEX = 23;

    private static final int SCAN_RECORD_INSTANCE_ID_LENGTH = 6;

    private static final int MASK = 0x00FF;

    private final StringBuilder instanceIdBuilder = new StringBuilder();

    private static final String FORMAT = "%02x";

    @Override
    public byte[] extract(byte[] scanRecord) {
        return ConversionUtils.extractPayload(
                scanRecord,
                INSTANCE_ID_START_INDEX,
                SCAN_RECORD_INSTANCE_ID_LENGTH
        );
    }

    @Override
    public String parse(byte[] source) {

        if(source == null) {
            return null;
        }

        instanceIdBuilder.setLength(0);

        for (byte byteValue : source) {
            instanceIdBuilder.append(String.format(FORMAT, byteValue & MASK));
        }

        return instanceIdBuilder.toString();
    }
}
