package com.kontakt.sdk.android.ble.discovery.eddystone;

/**
 * Eddystone TLM advertising packet. The telemetry packet provides information
 *
 * The TLM advertising packet has the following structure:
 *<ul>
 *     <li>[0] - TLM version</li>
 *     <li>[1]..[2] - battery voltage</li>
 *     <li>[3]..[4] - beacon temperature</li>
 *     <li>[5]..[8] - Advertising PDU Count</li>
 *     <li>[9]..[12] - Second resolution counter</li>
 *</ul>
 */
public interface EddystoneTLMAdvertisingPacket {

    /**
     * Provides TLM bytes.
     *
     * @return the telemetry bytes
     */
    byte[] getTLMBytes();

    /**
     * Provides battery voltage.
     *
     * @return the battery voltage
     */
    int getBatteryVoltage();

    /**
     * Provides temperature.
     *
     * @return the temperature
     */
    double getTemperature();

    /**
     * Provides pdu count.
     *
     * @return the pdu count
     */
    int getPduCount();

    /**
     * Provides time since power up.
     *
     * @return the time since power up
     */
    int getTimeSincePowerUp();

    /**
     * Provides telemetry version.
     *
     * @return the telemetry version
     */
    int getTelemetryVersion();
}
