package com.kontakt.sdk.android.ble.discovery;

import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import java.util.Collections;
import java.util.List;

/**
 * Provides abstraction for every event included in kontakt.io Android SDK.
 */
public abstract class AbstractBluetoothDeviceEvent implements BluetoothDeviceEvent {

  protected static final String PARCELABLE_EVENT_TYPE = "kontakt_event_type";

  protected static final String PARCELABLE_DEVICE_LIST = "remote_device_list";

  protected static final String PARCELABLE_TIMESTAMP = "timestamp";

  protected final long timestamp;

  protected List<? extends RemoteBluetoothDevice> deviceList;

  protected final EventType eventType;

  private final DeviceProfile deviceProfile;

  private final int hashCode;

  protected AbstractBluetoothDeviceEvent(EventType eventType, DeviceProfile deviceProfile, List<? extends RemoteBluetoothDevice> deviceList,
      long timestamp) {
    this.eventType = eventType;
    this.deviceProfile = deviceProfile;
    this.deviceList = deviceList;
    this.timestamp = timestamp;
    this.hashCode = HashCodeBuilder.init().append(eventType).append(deviceProfile).append(timestamp).append(deviceList.size()).build();
  }

  @Override
  public EventType getEventType() {
    return eventType;
  }

  @Override
  /**
   * Provides device list.
   *
   * @return the device list
   */ public List<? extends RemoteBluetoothDevice> getDeviceList() {
    return Collections.unmodifiableList(deviceList);
  }

  @Override
  public long getTimestamp() {
    return timestamp;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || !(o instanceof AbstractBluetoothDeviceEvent)) {
      return false;
    }

    AbstractBluetoothDeviceEvent abstractBluetoothDeviceEvent = (AbstractBluetoothDeviceEvent) o;

    return this.eventType == abstractBluetoothDeviceEvent.eventType &&
        this.deviceProfile == abstractBluetoothDeviceEvent.deviceProfile &&
        this.timestamp == abstractBluetoothDeviceEvent.timestamp;
  }

  @Override
  public DeviceProfile getDeviceProfile() {
    return deviceProfile;
  }

  @Override
  public int hashCode() {
    return hashCode;
  }
}
