package com.kontakt.sdk.android.ble.device;

import android.os.Bundle;
import android.os.Parcel;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.Constants;

/**
 * {@link IEddystoneNamespace} implementation.
 */
public class EddystoneNamespace implements IEddystoneNamespace {

  /**
   * Predefined constant specifying that every visible remote Eddystone device should be notified
   * by Android device regardless of its belonging to the specific namespace.
   */
  public static EddystoneNamespace EVERYWHERE = new EddystoneNamespace("Everywhere", "", false);

  /**
   * The constant CREATOR.
   */
  public static final Creator<EddystoneNamespace> CREATOR = new Creator<EddystoneNamespace>() {
    @Override
    public EddystoneNamespace createFromParcel(Parcel source) {
      Bundle bundle = source.readBundle(getClass().getClassLoader());

      return new EddystoneNamespace(bundle.getString("name"), bundle.getString(Constants.Eddystone.URL), bundle.getBoolean("isShuffled"));
    }

    @Override
    public EddystoneNamespace[] newArray(int size) {
      return new EddystoneNamespace[size];
    }
  };

  private final String name;
  private final String namespace;
  private final boolean isShuffled;
  private final int hashCode;

  public static EddystoneNamespace create(String name, String namespace, boolean isShuffled) {
    return new EddystoneNamespace(name, namespace, isShuffled);
  }

  private EddystoneNamespace(String name, String namespace, boolean isShuffled) {
    this.namespace = namespace;
    this.name = name;
    this.isShuffled = isShuffled;
    this.hashCode = namespace.hashCode();
  }

  @Override
  public String getNamespace() {
    return namespace;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public boolean isShuffled() {
    return isShuffled;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }

    if (o == null || !(o instanceof EddystoneNamespace)) {
      return false;
    }

    final EddystoneNamespace eddystoneNamespace = (EddystoneNamespace) o;

    return namespace.equals(eddystoneNamespace.namespace);
  }

  @Override
  public int compareTo(IEddystoneNamespace another) {
    if (this == another) {
      return 0;
    }

    return namespace.compareTo(another.getNamespace());
  }

  @Override
  public int hashCode() {
    return hashCode;
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(Parcel parcel, int flags) {
    Bundle bundle = new Bundle(getClass().getClassLoader());
    bundle.putString(Constants.Eddystone.URL, namespace);
    bundle.putString("name", name);
    bundle.putBoolean("isShuffled", isShuffled);

    parcel.writeBundle(bundle);
  }
}
