/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.spec;

import com.kontakt.sdk.android.ble.spec.GattServiceModel;
import java.util.UUID;

public enum KontaktDeviceService implements GattServiceModel
{
    GENERIC_ACCESS("00001800-0000-1000-8000-00805f9b34fb", "Generic Access"),
    GENERIC_ATTRIBUTE("00001801-0000-1000-8000-00805f9b34fb", "Generic Attribute"),
    DEVICE_INFORMATION("0000180a-0000-1000-8000-00805f9b34fb", "Device Information"),
    TX_POWER("00001804-0000-1000-8000-00805f9b34fb", "TxPower"),
    BATTERY_LEVEL("0000180f-0000-1000-8000-00805f9b34fb", "Battery Service"),
    PROXIMITY("a1ea8110-0e1b-d4a1-b840-63f88c8da1ea", "Proximity Service"),
    TIMERS("a1ea8120-0e1b-d4a1-b840-63f88c8da1ea", "Timers"),
    CONTROL("a1ea8130-0e1b-d4a1-b840-63f88c8da1ea", "Control Service"),
    DFU_SERVICE("00001530-1212-efde-1523-785feabcd123", "Firmware upgrade Service"),
    SENSORS_SERVICE("a1ea8210-0e1b-d4a1-b840-63f88c8da1ea", "Sensors service"),
    SECURE_CONFUGIRATION_SERVICE("A1EA81F0-0E1B-D4A1-B840-63F88C8DA1EA", "Secure config service");

    private final UUID id;
    private final String name;

    private KontaktDeviceService(String uuidString, String name) {
        this.name = name;
        this.id = UUID.fromString(uuidString);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static KontaktDeviceService valueOf(UUID id) {
        for (KontaktDeviceService value : KontaktDeviceService.values()) {
            if (!value.getId().equals(id)) continue;
            return value;
        }
        return null;
    }
}

