/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import com.kontakt.sdk.android.ble.manager.ProximityManager;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.MonitorCallback;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.Collection;

@TargetApi(value=21)
abstract class MonitorCallbackL
extends ScanCallback
implements BleScanCallback {
    protected final MonitorCallback wrappedScanCallback;

    MonitorCallbackL(MonitorCallback scanCallback) {
        SDKPreconditions.checkNotNull((Object)scanCallback, (Object)"Wrapped scan callback is null");
        this.wrappedScanCallback = scanCallback;
    }

    public void onScanResult(int callbackType, ScanResult result) {
        if (callbackType != 1) {
            return;
        }
        ScanRecord scanRecord = result.getScanRecord();
        if (scanRecord == null) {
            return;
        }
        this.onLeScan(result.getDevice(), result.getRssi(), scanRecord.getBytes());
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        this.wrappedScanCallback.onLeScan(device, rssi, scanRecord);
    }

    public void onScanFailed(int errorCode) {
        switch (errorCode) {
            case 4: {
                Logger.d((String)"Scan failed - feature unsupported");
                break;
            }
            case 3: {
                Logger.d((String)"Scan failed - internal error");
                break;
            }
            case 2: {
                Logger.d((String)"Scan failed - application registration failed");
                break;
            }
            case 1: {
                Logger.d((String)"Scan failed - application already started");
                break;
            }
            default: {
                Logger.d((String)("Scan failed - error code = " + errorCode));
            }
        }
    }

    @Override
    public Collection<ProximityManager.ProximityListener> getMonitoringListeners() {
        return this.wrappedScanCallback.getMonitoringListeners();
    }

    @Override
    public void addListener(ProximityManager.ProximityListener proximityListener) {
        this.wrappedScanCallback.addListener(proximityListener);
    }

    @Override
    public void removeListener(ProximityManager.ProximityListener proximityListener) {
        this.wrappedScanCallback.removeListener(proximityListener);
    }

    @Override
    public void close() throws IOException {
        this.wrappedScanCallback.close();
    }

    void onMonitorStarted() {
        this.wrappedScanCallback.onScanStarted();
    }

    void onMonitorStopped() {
        this.wrappedScanCallback.onScanStopped();
    }

    void notifyScanStarted() {
        this.wrappedScanCallback.notifyScanStarted();
    }

    void notifyScanStopped() {
        this.wrappedScanCallback.notifyScanStopped();
    }
}

