/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.os.Messenger;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.manager.ProximityManager;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.MonitorCallback;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

final class Callbacks {
    private Callbacks() {
    }

    static BleScanCallback newCallback(Configuration configuration) {
        SDKPreconditions.checkNotNull((Object)configuration, (Object)"Configuration cannot be null");
        return new MonitorCallback(configuration){};
    }

    static final class Configuration {
        final ScanContext scanContext;
        final Collection<ProximityManager.ProximityListener> proximityListeners;
        final Messenger messenger;

        private Configuration(ScanContext scanContext, Collection<ProximityManager.ProximityListener> proximityListeners, Messenger messenger) {
            this.scanContext = scanContext;
            this.proximityListeners = Collections.unmodifiableCollection(proximityListeners);
            this.messenger = messenger;
        }

        static class Builder {
            private ScanContext scanContext;
            private Messenger messenger;
            private final Collection<ProximityManager.ProximityListener> proximityListeners = new ArrayList<ProximityManager.ProximityListener>();

            Builder() {
            }

            Builder setScanContext(ScanContext scanContext) {
                this.scanContext = scanContext;
                return this;
            }

            Builder setServiceMessenger(Messenger messenger) {
                this.messenger = messenger;
                return this;
            }

            Builder addMonitoringListeners(Collection<ProximityManager.ProximityListener> proximityListeners) {
                this.proximityListeners.addAll(proximityListeners);
                return this;
            }

            Configuration build() {
                return new Configuration(this.scanContext, this.proximityListeners, this.messenger);
            }
        }
    }
}

