/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.math;

import com.kontakt.sdk.android.ble.math.AbstractStorelessUnivariateStatistic;
import com.kontakt.sdk.android.ble.math.FirstMoment;
import com.kontakt.sdk.android.ble.math.Sum;

public final class Mean
extends AbstractStorelessUnivariateStatistic {
    protected FirstMoment moment;
    protected boolean incMoment;

    public Mean() {
        this.incMoment = true;
        this.moment = new FirstMoment();
    }

    public Mean(FirstMoment m1) {
        this.moment = m1;
        this.incMoment = false;
    }

    @Override
    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    @Override
    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    @Override
    public double getResult() {
        return this.moment.m1;
    }

    @Override
    public long getN() {
        return this.moment.getN();
    }

    @Override
    public double evaluate(double[] values, int begin, int length) {
        if (this.test(values, begin, length)) {
            Sum sum = new Sum();
            double sampleSize = length;
            double xbar = sum.evaluate(values, begin, length) / sampleSize;
            double correction = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                correction += values[i] - xbar;
            }
            return xbar + correction / sampleSize;
        }
        return Double.NaN;
    }
}

