/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.math;

import com.kontakt.sdk.android.ble.math.AbstractStorelessUnivariateStatistic;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

class FirstMoment
extends AbstractStorelessUnivariateStatistic {
    protected long n;
    protected double m1;
    protected double dev;
    protected double nDev;

    public FirstMoment() {
        this.n = 0L;
        this.m1 = Double.NaN;
        this.dev = Double.NaN;
        this.nDev = Double.NaN;
    }

    public FirstMoment(FirstMoment original) throws NullPointerException {
        FirstMoment.copy(original, this);
    }

    @Override
    public void increment(double d) {
        if (this.n == 0L) {
            this.m1 = 0.0;
        }
        ++this.n;
        double n0 = this.n;
        this.dev = d - this.m1;
        this.nDev = this.dev / n0;
        this.m1 += this.nDev;
    }

    @Override
    public void clear() {
        this.m1 = Double.NaN;
        this.n = 0L;
        this.dev = Double.NaN;
        this.nDev = Double.NaN;
    }

    @Override
    public double getResult() {
        return this.m1;
    }

    @Override
    public long getN() {
        return this.n;
    }

    private static void copy(FirstMoment source, FirstMoment dest) {
        SDKPreconditions.checkNotNull((Object)dest);
        SDKPreconditions.checkNotNull((Object)source);
        dest.setData(source.getDataRef());
        dest.n = source.n;
        dest.m1 = source.m1;
        dest.dev = source.dev;
        dest.nDev = source.nDev;
    }
}

