/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.math;

import com.kontakt.sdk.android.ble.math.UnivariateStatistic;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    private double[] storedData;

    AbstractUnivariateStatistic() {
    }

    public void setData(double[] values) {
        this.storedData = values == null ? null : (double[])values.clone();
    }

    public double[] getData() {
        return this.storedData == null ? null : (double[])this.storedData.clone();
    }

    protected double[] getDataRef() {
        return this.storedData;
    }

    public void setData(double[] values, int begin, int length) {
        SDKPreconditions.checkState((values != null ? 1 : 0) != 0);
        SDKPreconditions.checkState((begin >= 0 ? 1 : 0) != 0);
        SDKPreconditions.checkState((length >= 0 ? 1 : 0) != 0);
        SDKPreconditions.checkState((begin + length <= values.length ? 1 : 0) != 0);
        this.storedData = new double[length];
        System.arraycopy(values, begin, this.storedData, 0, length);
    }

    public double evaluate() {
        return this.evaluate(this.storedData);
    }

    @Override
    public double evaluate(double[] values) {
        this.test(values, 0, 0);
        return this.evaluate(values, 0, values.length);
    }

    @Override
    public abstract double evaluate(double[] var1, int var2, int var3);

    protected boolean test(double[] values, int begin, int length) {
        return AbstractUnivariateStatistic.verifyValues(values, begin, length, false);
    }

    protected boolean test(double[] values, int begin, int length, boolean allowEmpty) {
        return AbstractUnivariateStatistic.verifyValues(values, begin, length, allowEmpty);
    }

    protected boolean test(double[] values, double[] weights, int begin, int length) {
        return AbstractUnivariateStatistic.verifyValues(values, weights, begin, length, false);
    }

    public static boolean verifyValues(double[] values, double[] weights, int begin, int length, boolean allowEmpty) {
        SDKPreconditions.checkNotNull((Object)weights);
        SDKPreconditions.checkNotNull((Object)values);
        SDKPreconditions.checkState((weights.length == values.length ? 1 : 0) != 0);
        boolean containsPositiveWeight = false;
        for (int i = begin; i < begin + length; ++i) {
            double weight = weights[i];
            SDKPreconditions.checkState((!Double.isNaN(weight) ? 1 : 0) != 0);
            SDKPreconditions.checkState((!Double.isInfinite(weight) ? 1 : 0) != 0);
            SDKPreconditions.checkState((weight >= 0.0 ? 1 : 0) != 0);
            if (containsPositiveWeight || !(weight > 0.0)) continue;
            containsPositiveWeight = true;
        }
        SDKPreconditions.checkState((boolean)containsPositiveWeight);
        return AbstractUnivariateStatistic.verifyValues(values, begin, length, allowEmpty);
    }

    protected boolean test(double[] values, double[] weights, int begin, int length, boolean allowEmpty) {
        return AbstractUnivariateStatistic.verifyValues(values, weights, begin, length, allowEmpty);
    }

    public static boolean verifyValues(double[] values, int begin, int length, boolean allowEmpty) {
        SDKPreconditions.checkNotNull((Object)values);
        SDKPreconditions.checkState((begin >= 0 ? 1 : 0) != 0);
        SDKPreconditions.checkState((length >= 0 ? 1 : 0) != 0);
        SDKPreconditions.checkState((begin + length <= values.length ? 1 : 0) != 0);
        return length != 0 || allowEmpty;
    }
}

