/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.connection.OnServiceReadyListener;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.manager.AbstractServiceConnector;
import com.kontakt.sdk.android.ble.manager.ProximityManagerContract;
import com.kontakt.sdk.android.ble.service.ProximityService;
import com.kontakt.sdk.android.common.interfaces.SDKSupplier;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class ProximityManager
extends AbstractServiceConnector
implements ProximityManagerContract {
    public static final int SCAN_MODE_LOW_POWER = 0;
    public static final int SCAN_MODE_BALANCED = 1;
    public static final int SCAN_MODE_LOW_LATENCY = 2;
    public static final long DEFAULT_DEVICES_UPDATE_CALLBACK_INTERVAL = 100L;
    private static final String TAG = ProximityManager.class.getSimpleName();
    private final int id;
    private Context context;
    private ServiceConnection serviceConnection;
    private Messenger serviceMessenger;
    private Messenger managerMessenger;
    private boolean isScanning;

    public ProximityManager(Context ctx) {
        super(ctx, new String[]{"android.permission.BLUETOOTH", "android.permission.BLUETOOTH_ADMIN"});
        this.context = ctx.getApplicationContext();
        this.managerMessenger = new Messenger((Handler)new ManagerHandler(this));
        this.id = System.identityHashCode(this);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @TargetApi(value=15)
    public synchronized void connect(final OnServiceReadyListener onServiceReadyistener) {
        if (this.isConnected()) {
            Logger.d((String)"ProximityManager already connected to BeaconService.");
            return;
        }
        SDKPreconditions.checkNotNull((Object)onServiceReadyistener, (Object)"OnServiceBoundListener is null.");
        this.checkPermissions();
        Intent serviceIntent = new Intent(this.context, ProximityService.class);
        this.serviceConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder serviceBinder) {
                Logger.d((String)(TAG + ": Beacon Service connected."));
                SDKSupplier messengerSupplier = (SDKSupplier)serviceBinder;
                ProximityManager.this.serviceMessenger = (Messenger)messengerSupplier.get();
                onServiceReadyistener.onServiceReady();
            }

            public void onServiceDisconnected(ComponentName name) {
                Logger.e((String)(TAG + ": disconnected from Beacon Service"));
            }
        };
        boolean isBindRequestSent = this.context.bindService(serviceIntent, this.serviceConnection, 1);
        if (!isBindRequestSent) {
            String serviceName = this.getClass().getSimpleName();
            Logger.i((String)String.format("Could not connect to %s. Please check if the %s is registered in AndroidManifest.xml", serviceName, serviceName));
            onServiceReadyistener.onConnectionFailure();
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.serviceConnection != null && this.serviceMessenger != null;
    }

    @Override
    public synchronized boolean initializeScan(ScanContext scanContext) {
        SDKPreconditions.checkNotNull((Object)scanContext, (Object)"ScanContext cannot be null");
        return this.startScanIfConnected(scanContext, 4);
    }

    @Override
    public void initializeScan(ScanContext scanContext, OnServiceReadyListener onServiceReadyListener) {
        SDKPreconditions.checkNotNull((Object)scanContext, (Object)"ScanContext cannot be null");
        SDKPreconditions.checkNotNull((Object)onServiceReadyListener, (Object)"onServiceReadyListener is null");
        this.connectIfNeededAndStartScan(scanContext, onServiceReadyListener, 4);
    }

    @Override
    public synchronized boolean restartScan(ScanContext scanContext) {
        SDKPreconditions.checkNotNull((Object)scanContext, (Object)"ScanContext cannot be null");
        return this.startScanIfConnected(scanContext, 3);
    }

    private void connectIfNeededAndStartScan(final ScanContext scanContext, final OnServiceReadyListener onServiceReadyListener, int messageCode) {
        if (this.isConnected()) {
            boolean isScanStartScheduled = this.startScanIfConnected(scanContext, messageCode);
            if (isScanStartScheduled) {
                onServiceReadyListener.onServiceReady();
            } else {
                onServiceReadyListener.onConnectionFailure();
            }
        } else {
            this.connect(new OnServiceReadyListener(){

                @Override
                public void onServiceReady() {
                    ProximityManager.this.initializeScan(scanContext);
                    onServiceReadyListener.onServiceReady();
                }

                @Override
                public void onConnectionFailure() {
                    onServiceReadyListener.onConnectionFailure();
                }
            });
        }
    }

    @Override
    public void restartScan(ScanContext scanContext, OnServiceReadyListener onServiceReadyListener) {
        SDKPreconditions.checkNotNull((Object)scanContext, (Object)"ScanContext cannot be null");
        SDKPreconditions.checkNotNull((Object)onServiceReadyListener, (Object)"onServiceReadyListener is null");
        this.connectIfNeededAndStartScan(scanContext, onServiceReadyListener, 3);
    }

    @Override
    public synchronized boolean attachListener(ProximityListener proximityListener) {
        SDKPreconditions.checkNotNull((Object)proximityListener, (Object)"Proximity listener is null");
        Message message = this.createMessage(6, proximityListener);
        return this.sendMessage(message);
    }

    @Override
    public synchronized boolean detachListener(ProximityListener proximityListener) {
        SDKPreconditions.checkNotNull((Object)proximityListener, (Object)"Proximity listener is null");
        Message message = this.createMessage(7, proximityListener);
        return this.sendMessage(message);
    }

    private boolean sendMessage(Message message) {
        if (this.isConnected()) {
            try {
                this.serviceMessenger.send(message);
                return true;
            }
            catch (RemoteException e) {
                return false;
            }
        }
        Logger.i((String)"BeaconManager already disconnected");
        return false;
    }

    @Override
    public synchronized boolean finishScan() {
        if (!this.isConnected()) {
            Logger.d((String)"BeaconManger not connected");
            return true;
        }
        if (!this.isScanning()) {
            Logger.d((String)"BeaconManager is not scanning");
            return true;
        }
        Message message = this.createMessage(5, null);
        return this.sendMessage(message);
    }

    @Override
    public synchronized void disconnect() {
        if (!this.isConnected()) {
            Logger.d((String)(TAG + ": BeaconManager already disconnected."));
            return;
        }
        if (this.isScanning()) {
            this.finishScan();
        }
        try {
            if (this.serviceConnection != null) {
                Message message = this.createMessage(8, null);
                this.serviceMessenger.send(message);
                this.context.unbindService(this.serviceConnection);
                this.serviceConnection = null;
                this.serviceMessenger = null;
            }
            super.disconnect();
        }
        catch (RemoteException e) {
            Logger.e((String)(TAG + ": unexpected exception thrown while disconnecting from Beacon Service "), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized boolean isScanning() {
        return this.isScanning;
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void clearBuffers() {
    }

    private boolean startScanIfConnected(ScanContext scanContext, int messageCode) {
        boolean isInitializationRequest;
        boolean bl = isInitializationRequest = messageCode == 4;
        if (isInitializationRequest && this.isScanning()) {
            Logger.d((String)(TAG + ": BeaconManager is already scanning"));
            return false;
        }
        Message message = this.createMessage(messageCode, scanContext);
        return this.sendMessage(message);
    }

    private Message createMessage(int messageCode, Object obj) {
        Message message = Message.obtain(null, (int)messageCode, (int)this.id, (int)-1, (Object)obj);
        message.replyTo = this.managerMessenger;
        return message;
    }

    public static interface ProximityListener {
        public void onScanStart();

        public void onScanStop();

        public void onEvent(BluetoothDeviceEvent var1);
    }

    private static class ManagerHandler
    extends Handler {
        private final ProximityManager manager;

        private ManagerHandler(ProximityManager manager) {
            this.manager = manager;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: 
                case 4: {
                    this.manager.isScanning = msg.arg1 == 201;
                    break;
                }
                case 5: 
                case 8: {
                    this.manager.isScanning = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported response code: " + msg.what);
                }
            }
        }
    }
}

