/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager;

import android.annotation.TargetApi;
import android.content.Context;
import com.kontakt.sdk.android.ble.manager.ServiceConnector;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

abstract class AbstractServiceConnector
implements ServiceConnector {
    private final String[] permissions;
    protected Context context;

    protected AbstractServiceConnector(Context context, String[] permissions) {
        SDKPreconditions.checkState((context != null ? 1 : 0) != 0, (Object)"Applied context instance is null");
        SDKPreconditions.checkState((permissions != null ? 1 : 0) != 0, (Object)"Permissions not specified");
        this.context = context.getApplicationContext();
        this.permissions = permissions;
    }

    @Override
    public void disconnect() {
        Logger.d((String)(this.getClass().getSimpleName() + " disconnected."));
    }

    @TargetApi(value=15)
    protected void checkPermissions() {
        for (String permission : this.permissions) {
            if (this.context.checkCallingOrSelfPermission(permission) == 0) continue;
            throw new RuntimeException(String.format("Permission %s is not granted", permission));
        }
    }
}

