/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.ibeacon;

import android.util.SparseArray;
import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconAdvertisingPacket;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.util.HashCodeBuilder;
import java.util.UUID;

class AdvertisingPacketImpl
implements IBeaconAdvertisingPacket {
    private final SparseArray<byte[]> advertisingData;
    private final UUID proximityUUID;
    private final int major;
    private final int minor;
    private final String beaconUniqueId;
    private final String firmwareVersion;
    private final int batteryPercentagePower;
    private final int txPower;
    private final int deviceHashCode;
    private final String name;
    private final String address;
    private long timestamp;
    private double distance;
    private double rssi;
    private Proximity proximity;
    private boolean shuffled;

    private AdvertisingPacketImpl(Builder builder) {
        this.advertisingData = builder.advertisingData;
        this.rssi = builder.rssi;
        this.proximityUUID = builder.proximityUUID;
        this.major = builder.major;
        this.minor = builder.minor;
        this.beaconUniqueId = builder.beaconUniqueId;
        this.firmwareVersion = builder.firmwareVersion;
        this.batteryPercentagePower = builder.batteryPercentagePower;
        this.txPower = builder.txPower;
        this.distance = builder.distance;
        this.proximity = builder.proximity;
        this.timestamp = builder.timestamp;
        this.name = builder.name;
        this.address = builder.address;
        this.shuffled = builder.shuffled;
        this.deviceHashCode = HashCodeBuilder.init().append((Object)builder.name).append((byte[])this.advertisingData.get(255)).build();
    }

    @Override
    public byte[] getManufacturerData() {
        return (byte[])this.advertisingData.get(255);
    }

    @Override
    public byte[] getServiceData() {
        return (byte[])this.advertisingData.get(22);
    }

    @Override
    public double getRssi() {
        return this.rssi;
    }

    @Override
    public UUID getProximityUUID() {
        return this.proximityUUID;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public String getBeaconUniqueId() {
        return this.beaconUniqueId;
    }

    @Override
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @Override
    public int getBatteryPercentagePower() {
        return this.batteryPercentagePower;
    }

    @Override
    public int getTxPower() {
        return this.txPower;
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public Proximity getProximity() {
        return this.proximity;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public int getDeviceHashCode() {
        return this.deviceHashCode;
    }

    @Override
    public boolean isShuffled() {
        return this.shuffled;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void setProximity(Proximity proximity) {
        this.proximity = proximity;
    }

    public void setRssi(double rssi) {
        this.rssi = rssi;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    static class Builder {
        private SparseArray<byte[]> advertisingData;
        private double rssi;
        private UUID proximityUUID;
        private int major;
        private int minor;
        private String beaconUniqueId;
        private String firmwareVersion;
        private int batteryPercentagePower;
        private int txPower;
        private double distance;
        private Proximity proximity;
        private long timestamp;
        private String address;
        private String name;
        private boolean shuffled;

        Builder() {
        }

        public Builder setRssi(double rssi) {
            this.rssi = rssi;
            return this;
        }

        public Builder setProximityUUID(UUID proximityUUID) {
            this.proximityUUID = proximityUUID;
            return this;
        }

        public Builder setMajor(int major) {
            this.major = major;
            return this;
        }

        public Builder setMinor(int minor) {
            this.minor = minor;
            return this;
        }

        public Builder setBeaconUniqueId(String beaconUniqueId) {
            this.beaconUniqueId = beaconUniqueId;
            return this;
        }

        public Builder setFirmwareVersion(String firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
            return this;
        }

        public Builder setBatteryPercentagePower(int batteryPercentagePower) {
            this.batteryPercentagePower = batteryPercentagePower;
            return this;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTxPower(int txPower) {
            this.txPower = txPower;
            return this;
        }

        public Builder setDistance(double distance) {
            this.distance = distance;
            return this;
        }

        public Builder setProximity(Proximity proximity) {
            this.proximity = proximity;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setAdvertisingData(SparseArray<byte[]> advertisingData) {
            this.advertisingData = advertisingData;
            return this;
        }

        public Builder setShuffled(boolean shuffled) {
            this.shuffled = shuffled;
            return this;
        }

        public AdvertisingPacketImpl build() {
            return new AdvertisingPacketImpl(this);
        }
    }
}

