/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import android.bluetooth.BluetoothDevice;
import android.text.TextUtils;
import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;
import com.kontakt.sdk.android.ble.configuration.scan.EddystoneScanContext;
import com.kontakt.sdk.android.ble.device.EddystoneDevice;
import com.kontakt.sdk.android.ble.device.EddystoneNamespace;
import com.kontakt.sdk.android.ble.discovery.AbstractBluetoothDeviceDiscoverer;
import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.DiscoveryContract;
import com.kontakt.sdk.android.ble.discovery.EventType;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneAdvertisingDataController;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneDeviceEvent;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneUIDAdvertisingPacket;
import com.kontakt.sdk.android.ble.spec.EddystoneFrameType;
import com.kontakt.sdk.android.ble.util.ReplacingArrayList;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import java.util.ArrayList;

public class EddystoneDiscoverer
extends AbstractBluetoothDeviceDiscoverer<IEddystoneNamespace, IEddystoneDevice> {
    private final EddystoneAdvertisingDataController controller;

    public EddystoneDiscoverer(EddystoneScanContext scanContext, ActivityCheckConfiguration activityCheckConfiguration, DiscoveryContract discoveryContract) {
        super(discoveryContract, scanContext.getDistanceSort(), scanContext.getEventTypes(), activityCheckConfiguration, scanContext.getSpaces(), scanContext.getDevicesUpdateCallbackInterval());
        this.controller = new EddystoneAdvertisingDataController(scanContext);
    }

    @Override
    protected BluetoothDeviceEvent createEvent(EventType eventType, IEddystoneNamespace eddystoneNamespace, ArrayList<IEddystoneDevice> deviceList) {
        return new EddystoneDeviceEvent(eventType, eddystoneNamespace, deviceList);
    }

    @Override
    protected void onBeforeDeviceLost(IEddystoneDevice device) {
        this.controller.clearRssiCalculation(device.getAddress().hashCode());
    }

    @Override
    public boolean performDiscovery(BluetoothDevice bluetoothDevice, int rssi, byte[] scanResult) {
        if (this.controller.isEnabled() && !EddystoneAdvertisingDataController.isEddystoneSpecificFrame(scanResult)) {
            return PROFILE_UNRECOGNIZED;
        }
        String deviceAddress = bluetoothDevice.getAddress();
        EddystoneFrameType frameType = EddystoneFrameType.fromScanRecord(scanResult);
        if (frameType == null) {
            return PROFILE_UNRECOGNIZED;
        }
        this.controller.cacheProperty(frameType, deviceAddress, scanResult);
        if (!this.controller.filter(deviceAddress)) {
            return PROFILE_RECOGNIZED_FILTERING_NOT_PASSED;
        }
        IEddystoneNamespace namespace = this.extractNamespace(this.controller.getNamespaceIfAllTriggersAreSatisfied(deviceAddress));
        if (namespace == null) {
            return PROFILE_RECOGNIZED_NO_BELONGING_SPACE_FOUND;
        }
        this.notifySpacePresent(namespace.hashCode(), System.currentTimeMillis());
        ReplacingArrayList<Object> deviceList = this.getDevicesInSpace(namespace);
        if (deviceList == null) {
            deviceList = new ReplacingArrayList();
            this.insertDevicesIntoSpace(namespace, deviceList);
            this.onSpaceEnteredEvent(namespace);
            return true;
        }
        EddystoneDevice device = this.controller.getOrCreateDevice(bluetoothDevice, rssi);
        if (device == null) {
            return PROFILE_RECOGNIZED_DEVICE_NOT_READY;
        }
        if (deviceList.addOrReplace(device)) {
            this.onDeviceDiscoveredEvent(namespace, device);
        } else {
            this.sortIfEnabled(deviceList);
            this.onDevicesUpdatedEvent(namespace, deviceList);
        }
        return true;
    }

    @Override
    public void disable() {
        this.controller.clearResources();
        this.controller.disable();
    }

    IEddystoneNamespace extractNamespace(EddystoneUIDAdvertisingPacket advertisingPacket) {
        if (advertisingPacket == null) {
            return null;
        }
        String namespaceId = advertisingPacket.getNamespaceId();
        for (IEddystoneNamespace namespace : this.getSpaceSet()) {
            if (namespace == EddystoneNamespace.EVERYWHERE) {
                return namespace;
            }
            if (!TextUtils.equals((CharSequence)namespace.getId(), (CharSequence)namespaceId)) continue;
            return namespace;
        }
        return null;
    }
}

