/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import com.kontakt.sdk.android.ble.connection.GattController;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnection;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceServiceStore;
import com.kontakt.sdk.android.ble.connection.WriteListener;
import com.kontakt.sdk.android.ble.device.KontaktDeviceCharacteristics;
import com.kontakt.sdk.android.ble.exception.ServiceAbsentException;
import com.kontakt.sdk.android.ble.spec.BluetoothDeviceCharacteristic;
import com.kontakt.sdk.android.ble.spec.KontaktDeviceCharacteristic;
import com.kontakt.sdk.android.ble.spec.KontaktDeviceService;
import com.kontakt.sdk.android.ble.util.BluetoothUtils;
import com.kontakt.sdk.android.common.TimestampUtil;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

@TargetApi(value=18)
final class NormalGattController
extends BluetoothGattCallback
implements Closeable,
GattController {
    private KontaktDeviceConnection contract;
    private BluetoothGatt gattServer;
    private KontaktDeviceServiceStore iBeaconServiceStore;
    private Handler uiHandler;
    private final byte[] beaconPassword;
    private Queue<BluetoothDeviceCharacteristic> preAuthCharacteristicsQueue;
    private Context context;
    private BluetoothDevice bluetoothDevice;
    private Runnable characteristicRequestRunnable = new Runnable(){

        @Override
        public void run() {
            if (NormalGattController.this.contract == null) {
                return;
            }
            if (NormalGattController.this.contract.getState() == KontaktDeviceConnection.State.AUTHENTICATING) {
                NormalGattController.this.contract.onConnectionStateChange(KontaktDeviceConnection.State.CHARACTERISTICS_REQUESTING);
                NormalGattController.this.requestCharacteristics();
            }
        }
    };

    NormalGattController(KontaktDeviceConnection contract, Context context, RemoteBluetoothDevice device) throws RemoteException {
        this.contract = contract;
        this.context = context;
        this.beaconPassword = device.getPassword();
        this.uiHandler = new Handler(Looper.getMainLooper());
        BluetoothDevice bluetoothDevice = BluetoothUtils.getBluetoothDevice(device.getAddress());
        if (bluetoothDevice == null) {
            throw new RemoteException("Bluetooth device is null");
        }
        this.bluetoothDevice = bluetoothDevice;
    }

    @Override
    public boolean connect() {
        this.gattServer = this.bluetoothDevice.connectGatt(this.context, false, (BluetoothGattCallback)this);
        return this.gattServer != null;
    }

    public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
        switch (newState) {
            case 2: {
                if (0 == status) {
                    this.contract.onConnectionStateChange(KontaktDeviceConnection.State.CONNECTED);
                    this.contract.onConnected();
                    if (this.gattServer.discoverServices()) break;
                    this.contract.onError(1);
                    break;
                }
                this.contract.onError(KontaktDeviceConnection.toGattError(status));
                break;
            }
            case 0: {
                if (this.contract == null) break;
                if (0 != status) {
                    this.contract.onError(KontaktDeviceConnection.toGattError(status));
                }
                if (this.contract != null && this.contract.getState() == KontaktDeviceConnection.State.AUTHENTICATING) {
                    this.contract.onFailure(7);
                }
                if (this.contract != null) {
                    this.contract.onConnectionStateChange(KontaktDeviceConnection.State.DISCONNECTED);
                }
                if (this.contract == null) break;
                this.contract.onDisconnected();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported connection state change code: " + newState);
            }
        }
    }

    public void onServicesDiscovered(BluetoothGatt gatt, int status) {
        Logger.d((String)String.format("On Services Discovered: %s ", gatt.toString()));
        if (status != 0) {
            Logger.v((String)("Services discovered but with no success: " + status));
            return;
        }
        try {
            this.iBeaconServiceStore = new KontaktDeviceServiceStore(gatt.getServices(), KontaktDeviceServiceStore.StoreType.NORMAL);
            this.contract.onServicesDiscovered(this.iBeaconServiceStore);
            if (this.iBeaconServiceStore.contains(KontaktDeviceService.DFU_SERVICE)) {
                this.contract.onDfuModeEnabled();
            } else {
                this.authorize(gatt);
            }
        }
        catch (RemoteException e) {
            this.contract.onFailure(4);
        }
    }

    public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        if (status == 0) {
            BluetoothDeviceCharacteristic wrapper = new BluetoothDeviceCharacteristic(characteristic);
            try {
                this.iBeaconServiceStore.replace(wrapper);
            }
            catch (ServiceAbsentException serviceAbsentException) {
                // empty catch block
            }
            if (this.contract.getState() == KontaktDeviceConnection.State.CHARACTERISTICS_REQUESTING) {
                this.requestOrSetAuthenticated();
            }
        } else if (status == 2 && this.contract.getState() == KontaktDeviceConnection.State.CHARACTERISTICS_REQUESTING) {
            this.requestOrSetAuthenticated();
        }
    }

    public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        if (this.contract.isConnected()) {
            try {
                this.iBeaconServiceStore.replace(new BluetoothDeviceCharacteristic(characteristic));
            }
            catch (ServiceAbsentException serviceAbsentException) {
                // empty catch block
            }
            boolean isSuccess = status == 0;
            KontaktDeviceCharacteristic beaconCharacteristic = KontaktDeviceCharacteristic.valueOf(characteristic.getUuid());
            if (beaconCharacteristic == null) {
                return;
            }
            if (beaconCharacteristic == KontaktDeviceCharacteristic.PASSWORD) {
                if (isSuccess) {
                    this.uiHandler.postDelayed(this.characteristicRequestRunnable, TimeUnit.SECONDS.toMillis(1L));
                    this.contract.onConnectionStateChange(KontaktDeviceConnection.State.AUTHENTICATING);
                } else {
                    this.contract.onConnectionStateChange(KontaktDeviceConnection.State.CONNECTED);
                    this.contract.onError(3);
                }
            } else {
                this.contract.onCharacteristicWritten(isSuccess, new WriteListener.WriteResponse(TimestampUtil.getTimestamp(), null));
                if (isSuccess && this.contract != null) {
                    this.contract.notifyDataSetChanged();
                }
            }
        }
    }

    @Override
    public void disconnect() {
        if (this.gattServer != null) {
            this.refresh();
            this.gattServer.disconnect();
        }
    }

    @Override
    public boolean writeCharacteristic(BluetoothGattCharacteristic characteristic) {
        return this.gattServer.writeCharacteristic(characteristic);
    }

    @Override
    public boolean writeCharacteristic(BluetoothGattCharacteristic characteristic, boolean readResponse) {
        throw new UnsupportedOperationException("Not supported in normal mode");
    }

    @Override
    public void refresh() {
        BluetoothUtils.refreshGattServer(this.gattServer);
    }

    @Override
    public void close() throws IOException {
        if (this.gattServer != null) {
            this.disconnect();
            this.gattServer.close();
        }
        if (this.iBeaconServiceStore != null) {
            this.iBeaconServiceStore.clear();
        }
        if (this.preAuthCharacteristicsQueue != null) {
            this.preAuthCharacteristicsQueue.clear();
        }
        this.contract = null;
        this.uiHandler.removeCallbacks(this.characteristicRequestRunnable);
    }

    private void requestOrSetAuthenticated() {
        if (this.preAuthCharacteristicsQueue.isEmpty()) {
            this.contract.onConnectionStateChange(KontaktDeviceConnection.State.AUTHENTICATED);
            this.contract.onAuthenticationSuccess(new KontaktDeviceCharacteristics(this.iBeaconServiceStore));
        } else {
            this.request(this.preAuthCharacteristicsQueue.poll());
        }
    }

    private void requestCharacteristics() {
        Collection<BluetoothDeviceCharacteristic> readableCharacteristics = this.iBeaconServiceStore.getReadableCharacteristics();
        if (this.preAuthCharacteristicsQueue == null) {
            this.preAuthCharacteristicsQueue = new ArrayDeque<BluetoothDeviceCharacteristic>(readableCharacteristics.size());
        } else {
            this.preAuthCharacteristicsQueue.clear();
        }
        this.preAuthCharacteristicsQueue.addAll(readableCharacteristics);
        this.request(this.preAuthCharacteristicsQueue.poll());
    }

    @TargetApi(value=18)
    private void request(BluetoothDeviceCharacteristic wrapper) {
        if (!this.gattServer.readCharacteristic((BluetoothGattCharacteristic)wrapper) && this.contract != null && this.contract.getState() == KontaktDeviceConnection.State.CHARACTERISTICS_REQUESTING) {
            this.requestOrSetAuthenticated();
        }
    }

    @TargetApi(value=18)
    private void authorize(BluetoothGatt gatt) {
        try {
            BluetoothDeviceCharacteristic passwordCharacteristic = this.iBeaconServiceStore.getPasswordCharacteristic();
            passwordCharacteristic.setValue(this.beaconPassword);
            if (!gatt.writeCharacteristic((BluetoothGattCharacteristic)passwordCharacteristic)) {
                this.contract.onError(3);
            }
        }
        catch (Exception ignored) {
            this.contract.onError(3);
        }
    }
}

