/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.os.RemoteException;
import com.kontakt.sdk.android.ble.exception.CharacteristicAbsentException;
import com.kontakt.sdk.android.ble.exception.ServiceAbsentException;
import com.kontakt.sdk.android.ble.spec.BluetoothDeviceCharacteristic;
import com.kontakt.sdk.android.ble.spec.GattServiceStore;
import com.kontakt.sdk.android.ble.spec.KontaktDeviceCharacteristic;
import com.kontakt.sdk.android.ble.spec.KontaktDeviceService;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class KontaktDeviceServiceStore
implements GattServiceStore {
    private static final KontaktDeviceService REQUIRED_SERVICE_NORMAL_MODE = KontaktDeviceService.CONTROL;
    private static final KontaktDeviceService REQUIRED_SERVICE_SECURE_MODE = KontaktDeviceService.SECURE_CONFUGIRATION_SERVICE;
    private final Map<KontaktDeviceService, Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic>> storeMap;
    private final StoreType storeType;

    @TargetApi(value=18)
    public KontaktDeviceServiceStore(List<BluetoothGattService> gattServices, StoreType storeType) throws RemoteException {
        SDKPreconditions.checkNotNullOrEmpty(gattServices, (String)"Gatt Service list is null.");
        this.storeMap = new HashMap<KontaktDeviceService, Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic>>(gattServices.size());
        this.storeType = storeType;
        switch (storeType) {
            case NORMAL: {
                this.createNormalMode(gattServices);
                break;
            }
            case SECURE: {
                this.createSecureMode(gattServices);
            }
        }
        try {
            this.assertRequiredServiceFound(storeType);
            this.assertRequiredServicesFoundIfDfuModeEnabled();
        }
        catch (ServiceAbsentException e) {
            throw new RemoteException("Beacon is not recognized as product of kontakt.io company");
        }
    }

    private void createNormalMode(List<BluetoothGattService> gattServices) {
        for (BluetoothGattService service : gattServices) {
            KontaktDeviceService serviceModel = this.getServiceModel(service.getUuid());
            if (serviceModel == null) continue;
            Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic> characteristics = this.storeMap.get(serviceModel);
            List gattCharacteristics = service.getCharacteristics();
            if (characteristics == null) {
                characteristics = new HashMap<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic>(gattCharacteristics.size());
                this.storeMap.put(serviceModel, characteristics);
            }
            for (BluetoothGattCharacteristic gattCharacteristic : gattCharacteristics) {
                KontaktDeviceCharacteristic characteristicModel = this.getCharacteristicModel(gattCharacteristic.getUuid());
                if (characteristicModel == null) continue;
                characteristics.put(characteristicModel, new BluetoothDeviceCharacteristic(gattCharacteristic));
            }
        }
    }

    private void createSecureMode(List<BluetoothGattService> gattServices) {
        for (BluetoothGattService gattService : gattServices) {
            KontaktDeviceService secureService = KontaktDeviceService.valueOf(gattService.getUuid());
            if (secureService == null) continue;
            Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic> characteristics = this.storeMap.get(secureService);
            if (characteristics == null) {
                characteristics = new HashMap<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic>();
                this.storeMap.put(secureService, characteristics);
            }
            List bluetoothGattCharacteristics = gattService.getCharacteristics();
            for (BluetoothGattCharacteristic gattCharacteristic : bluetoothGattCharacteristics) {
                KontaktDeviceCharacteristic secureCharacteristic = KontaktDeviceCharacteristic.valueOf(gattCharacteristic.getUuid());
                if (secureCharacteristic == null) continue;
                characteristics.put(secureCharacteristic, new BluetoothDeviceCharacteristic(gattCharacteristic));
            }
        }
    }

    @Override
    public BluetoothDeviceCharacteristic getFirmwareRevisionCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.DEVICE_INFORMATION), KontaktDeviceCharacteristic.FIRMWARE_REVISION_STRING);
    }

    @Override
    public BluetoothDeviceCharacteristic getHardwareRevisionCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.DEVICE_INFORMATION), KontaktDeviceCharacteristic.HARDWARE_REVISION);
    }

    @Override
    public BluetoothDeviceCharacteristic getManufacturerNameCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.DEVICE_INFORMATION), KontaktDeviceCharacteristic.MANUFACTURER_NAME);
    }

    @Override
    public BluetoothDeviceCharacteristic getDeviceNameCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.GENERIC_ACCESS), KontaktDeviceCharacteristic.DEVICE_NAME);
    }

    @Override
    public BluetoothDeviceCharacteristic getPropagatedDeviceNameCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.PROPAGATED_DEVICE_NAME);
    }

    @Override
    public BluetoothDeviceCharacteristic getMinorCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.MINOR);
    }

    @Override
    public BluetoothDeviceCharacteristic getNonConnectableCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.NON_CONNECTABLE_MODE);
    }

    @Override
    public BluetoothDeviceCharacteristic getShuffleIntervalCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.SHUFFLE_INTERVAL);
    }

    @Override
    public BluetoothDeviceCharacteristic getShuffleKeyCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.SHUFFLE_KEY);
    }

    @Override
    public BluetoothDeviceCharacteristic getSensorOnCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.SENSORS_SERVICE), KontaktDeviceCharacteristic.SENSOR_ON);
    }

    @Override
    public BluetoothDeviceCharacteristic getAccelerometerCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.SENSORS_SERVICE), KontaktDeviceCharacteristic.ACCELEROMETER);
    }

    @Override
    public BluetoothDeviceCharacteristic getActiveProfileCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.ACTIVE_PROFILE);
    }

    @Override
    public BluetoothDeviceCharacteristic getMajorCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.MAJOR);
    }

    @Override
    public BluetoothDeviceCharacteristic getProximityCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.PROXIMITY_UUID);
    }

    @Override
    public BluetoothDeviceCharacteristic getPowerLevelCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.TX_POWER), KontaktDeviceCharacteristic.TX_POWER_LEVEL);
    }

    @Override
    public BluetoothDeviceCharacteristic getBatteryLevelCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.BATTERY_LEVEL), KontaktDeviceCharacteristic.BATTERY_LEVEL);
    }

    @Override
    public BluetoothDeviceCharacteristic getPasswordCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.PASSWORD);
    }

    @Override
    public BluetoothDeviceCharacteristic getMasterPasswordCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.MASTER_PASSWORD);
    }

    @Override
    public BluetoothDeviceCharacteristic getSetNewPasswordCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.SET_PASSWORD);
    }

    @Override
    public BluetoothDeviceCharacteristic getAdvertisingIntervalCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.TIMERS), KontaktDeviceCharacteristic.ADVERTISING_INTERVAL);
    }

    @Override
    public BluetoothDeviceCharacteristic getResetCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.RESET);
    }

    @Override
    public BluetoothDeviceCharacteristic getBootloaderCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.BOOTLOADER);
    }

    @Override
    public BluetoothDeviceCharacteristic getUniqueIdCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.BEACON_ID);
    }

    @Override
    public BluetoothDeviceCharacteristic getNamespaceIdCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.NAMESPACE_ID);
    }

    @Override
    public BluetoothDeviceCharacteristic getInstanceIdCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.INSTANCE_ID);
    }

    @Override
    public BluetoothDeviceCharacteristic getUrlCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.PROXIMITY), KontaktDeviceCharacteristic.URL_ID);
    }

    @Override
    public BluetoothDeviceCharacteristic getDefaultSettingsCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.CONTROL), KontaktDeviceCharacteristic.DEFAULT_SETTINGS);
    }

    @Override
    public BluetoothDeviceCharacteristic getSecureLastProcessedRequestTokenCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.SECURE_CONFUGIRATION_SERVICE), KontaktDeviceCharacteristic.SECURE_LAST_PROCESSED_REQUEST_TOKEN);
    }

    @Override
    public BluetoothDeviceCharacteristic getSecureWriteCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.SECURE_CONFUGIRATION_SERVICE), KontaktDeviceCharacteristic.SECURE_WRITE);
    }

    @Override
    public BluetoothDeviceCharacteristic getSecureResponseCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.SECURE_CONFUGIRATION_SERVICE), KontaktDeviceCharacteristic.SECURE_RESPONSE);
    }

    @Override
    public BluetoothDeviceCharacteristic getSecureControlPointCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException {
        return this.getCharacteristic(this.getService(KontaktDeviceService.SECURE_CONFUGIRATION_SERVICE), KontaktDeviceCharacteristic.SECURE_CONTROL_POINT);
    }

    public StoreType getStoreType() {
        return this.storeType;
    }

    @Override
    public boolean contains(KontaktDeviceService serviceModel) {
        return this.storeMap.containsKey(serviceModel);
    }

    @Override
    @TargetApi(value=18)
    public void replace(BluetoothDeviceCharacteristic characteristicWrapper) throws ServiceAbsentException {
        UUID serviceId = characteristicWrapper.getService().getUuid();
        UUID characteristicId = characteristicWrapper.getId();
        KontaktDeviceService serviceModel = this.getServiceModel(serviceId);
        KontaktDeviceCharacteristic characteristicModel = this.getCharacteristicModel(characteristicId);
        this.storeMap.get(serviceModel).put(characteristicModel, characteristicWrapper);
    }

    @Override
    public void clear() {
        this.storeMap.clear();
    }

    public final Collection<BluetoothDeviceCharacteristic> getReadableCharacteristics() {
        ArrayList<BluetoothDeviceCharacteristic> readableCharacteristics = new ArrayList<BluetoothDeviceCharacteristic>();
        for (Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic> characteristicMap : this.storeMap.values()) {
            for (BluetoothDeviceCharacteristic characteristic : characteristicMap.values()) {
                if (!characteristic.isReadable()) continue;
                readableCharacteristics.add(characteristic);
            }
        }
        return Collections.unmodifiableCollection(readableCharacteristics);
    }

    Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic> getService(KontaktDeviceService service) throws ServiceAbsentException {
        SDKPreconditions.checkNotNull((Object)service, (Object)"Service is null.");
        SDKPreconditions.checkArgument((boolean)this.contains(service), (Exception)new ServiceAbsentException(String.format("The Service %s was not found during services discovery", service)));
        return Collections.unmodifiableMap(this.storeMap.get(service));
    }

    BluetoothDeviceCharacteristic getCharacteristic(Map<KontaktDeviceCharacteristic, BluetoothDeviceCharacteristic> map, KontaktDeviceCharacteristic characteristic) throws CharacteristicAbsentException {
        SDKPreconditions.checkState((boolean)map.containsKey(characteristic), (Exception)new CharacteristicAbsentException(String.format("The characteristic %s is absent", characteristic == null ? "" : characteristic)));
        return map.get(characteristic);
    }

    private KontaktDeviceService getServiceModel(UUID serviceUUID) {
        return KontaktDeviceService.valueOf(serviceUUID);
    }

    private KontaktDeviceCharacteristic getCharacteristicModel(UUID characteristicUUID) {
        return KontaktDeviceCharacteristic.valueOf(characteristicUUID);
    }

    private void assertRequiredServiceFound(StoreType storeType) throws ServiceAbsentException {
        switch (storeType) {
            case NORMAL: {
                this.getService(REQUIRED_SERVICE_NORMAL_MODE);
                break;
            }
            case SECURE: {
                this.getService(REQUIRED_SERVICE_SECURE_MODE);
            }
        }
    }

    private void assertRequiredServicesFoundIfDfuModeEnabled() throws ServiceAbsentException {
        if (this.contains(KontaktDeviceService.DFU_SERVICE)) {
            EnumSet<KontaktDeviceService> requiredServices = EnumSet.of(KontaktDeviceService.GENERIC_ACCESS, KontaktDeviceService.GENERIC_ATTRIBUTE, KontaktDeviceService.DFU_SERVICE);
            for (KontaktDeviceService kontaktDeviceService : requiredServices) {
                this.getService(kontaktDeviceService);
            }
        }
    }

    public static enum StoreType {
        NORMAL,
        SECURE;

    }
}

