/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGattCharacteristic;
import android.content.Context;
import android.os.RemoteException;
import android.util.Base64;
import com.kontakt.sdk.android.ble.connection.GattController;
import com.kontakt.sdk.android.ble.connection.GattControllerFactory;
import com.kontakt.sdk.android.ble.connection.IKontaktDeviceConnection;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceBatchProcessor;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceServiceStore;
import com.kontakt.sdk.android.ble.connection.OperationWrite;
import com.kontakt.sdk.android.ble.connection.WriteBatchListener;
import com.kontakt.sdk.android.ble.connection.WriteListener;
import com.kontakt.sdk.android.ble.device.KontaktDeviceCharacteristics;
import com.kontakt.sdk.android.common.FirmwareRevisions;
import com.kontakt.sdk.android.common.KontaktSDK;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.model.IConfig;
import com.kontakt.sdk.android.common.model.IPreset;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.EddystonePropertyValidator;
import com.kontakt.sdk.android.common.util.EddystoneUtils;
import com.kontakt.sdk.android.common.util.IBeaconPropertyValidator;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;

public class KontaktDeviceConnection
implements IKontaktDeviceConnection {
    public static final int ERROR_SERVICES_DISCOVERY = 1;
    public static final int ERROR_OVERWRITE_REQUEST = 2;
    public static final int ERROR_AUTHENTICATION = 3;
    public static final int FAILURE_UNKNOWN_BEACON = 4;
    public static final int FAILURE_WRONG_PASSWORD = 7;
    public static final int ERROR_BATCH_WRITE_PROXIMITY_UUID = 8;
    public static final int ERROR_BATCH_WRITE_TX_POWER = 9;
    public static final int ERROR_BATCH_WRITE_MAJOR = 10;
    public static final int ERROR_BATCH_WRITE_MINOR = 11;
    public static final int ERROR_BATCH_WRITE_INTERVAL = 12;
    public static final int ERROR_BATCH_WRITE_PROFILE = 13;
    public static final int ERROR_BATCH_WRITE_NAMESPACE = 14;
    public static final int ERROR_BATCH_WRITE_INSTANCE_ID = 15;
    public static final int ERROR_BATCH_WRITE_URL = 16;
    public static final int ERROR_BATCH_WRITE_NAME = 17;
    public static final int ERROR_BATCH_WRITE_PASSWORD = 18;
    private static final int GATT_ERROR_BEGIN = 1000;
    private static final Set<State> CONNECTION_AVAILABLE_STATES = EnumSet.of(State.CONNECTED, State.AUTHENTICATED, State.AUTHENTICATING, State.CHARACTERISTICS_REQUESTING);
    private final RemoteBluetoothDevice beaconDevice;
    private IKontaktDeviceConnection.ConnectionListener connectionListener;
    private volatile State state = State.DISCONNECTED;
    private GattController gattController;
    private KontaktDeviceServiceStore serviceStore;
    private WriteListener writeListener = WriteListener.NULL_LISTENER;
    private Context context;
    private GattControllerFactory gattControllerFactory;

    static int toGattError(int errorCode) {
        return errorCode + 1000;
    }

    public static boolean isGattError(int errorCode) {
        return errorCode > 1000;
    }

    public static int getGattError(int errorCode) {
        if (!KontaktDeviceConnection.isGattError(errorCode)) {
            throw new IllegalArgumentException("Error code is not gatt error");
        }
        return errorCode - 1000;
    }

    public KontaktDeviceConnection(Context context, RemoteBluetoothDevice bluetoothDevice, IKontaktDeviceConnection.ConnectionListener connectionListener) {
        KontaktSDK.getInstance();
        SDKPreconditions.checkNotNull((Object)bluetoothDevice, (Object)"Beacon device is null.");
        SDKPreconditions.checkNotNull((Object)connectionListener, (Object)"Connection listener is null.");
        this.validateBeaconPassword(bluetoothDevice);
        this.context = context;
        this.beaconDevice = bluetoothDevice;
        this.connectionListener = connectionListener;
    }

    protected KontaktDeviceConnection(Context context, RemoteBluetoothDevice bluetoothDevice, IKontaktDeviceConnection.ConnectionListener connectionListener, KontaktDeviceServiceStore serviceStore) {
        this(context, bluetoothDevice, connectionListener);
        this.serviceStore = serviceStore;
    }

    @Override
    public RemoteBluetoothDevice getDevice() {
        return this.beaconDevice;
    }

    @Override
    @TargetApi(value=18)
    public synchronized boolean connect() {
        SDKPreconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"BeaconConnection is closed.");
        if (this.gattController == null) {
            try {
                this.gattController = GattControllerFactory.createGattController(this, this.getContext(), this.beaconDevice);
                return this.gattController.connect();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public synchronized boolean isConnected() {
        return CONNECTION_AVAILABLE_STATES.contains((Object)this.state);
    }

    @Override
    public synchronized boolean isAuthenticated() {
        return this.state == State.AUTHENTICATED;
    }

    @Override
    @TargetApi(value=18)
    public synchronized void close() {
        if (this.isConnected()) {
            this.disconnect();
        }
        Logger.v((String)"Closing connection");
        try {
            if (this.gattController != null) {
                this.gattController.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.gattController = null;
        this.connectionListener = null;
    }

    @TargetApi(value=18)
    private void disconnect() {
        if (this.gattController != null) {
            Logger.v((String)"Disconnecting from beacon device");
            this.gattController.disconnect();
        } else {
            Logger.v((String)"Connection was not initialized");
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this.gattController == null && this.connectionListener == null;
    }

    @Override
    public synchronized void applyConfig(IConfig config, WriteBatchListener<IConfig> writeBatchListener) {
        SDKPreconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"Beacon connection is closed");
        SDKPreconditions.checkState((boolean)this.isAuthenticated(), (Object)"Beacon connection is not authenticated");
        SDKPreconditions.checkNotNull(writeBatchListener, (Object)"Write Batch Listener is null.");
        OperationWrite.CONFIG.validate(this.beaconDevice);
        if (!this.isAuthenticated()) {
            writeBatchListener.onWriteFailure();
            return;
        }
        Logger.d((String)"Applying config...");
        KontaktDeviceCharacteristics characteristics = new KontaktDeviceCharacteristics(this.serviceStore);
        KontaktDeviceBatchProcessor.from(KontaktDeviceBatchProcessor.Batch.select(config, (RemoteBluetoothDevice.Characteristics)characteristics), this).process(KontaktDeviceConnection.createProcessingListener(config, writeBatchListener));
    }

    @Override
    public synchronized void acceptProfile(IPreset profile, WriteBatchListener<IPreset> writeBatchListener) {
        SDKPreconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"Beacon connection is closed");
        SDKPreconditions.checkState((boolean)this.isAuthenticated(), (Object)"Beacon connection is not authenticated");
        SDKPreconditions.checkNotNull(writeBatchListener, (Object)"Write Batch Listener is null.");
        OperationWrite.PROFILE.validate(this.beaconDevice);
        if (!this.isAuthenticated()) {
            writeBatchListener.onWriteFailure();
            return;
        }
        Logger.d((String)"Accepting profile...");
        KontaktDeviceCharacteristics characteristics = new KontaktDeviceCharacteristics(this.serviceStore);
        KontaktDeviceBatchProcessor.from(KontaktDeviceBatchProcessor.Batch.select(profile, (RemoteBluetoothDevice.Characteristics)characteristics), this).process(KontaktDeviceConnection.createProcessingListener(profile, writeBatchListener));
    }

    @Override
    public synchronized void overwriteMinor(int value, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null.");
        OperationWrite.MINOR.validate(this.beaconDevice);
        Logger.d((String)String.format("Writing new minor value %s ", String.valueOf(value)));
        try {
            IBeaconPropertyValidator.validateMinor((int)value);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getMinorCharacteristic(), ConversionUtils.invert((byte[])ConversionUtils.to2ByteArray((int)value)), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void enableNonConnectableMode(String masterPassword, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null.");
        OperationWrite.NON_CONNECTABLE_MODE.validate(this.beaconDevice);
        try {
            IBeaconPropertyValidator.validateBeaconMasterPassword((String)masterPassword);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
            return;
        }
        Logger.d((String)String.format("Enabling non-connectable mode - master password: %s", masterPassword));
        try {
            this.overwrite(this.serviceStore.getNonConnectableCharacteristic(), masterPassword.getBytes(), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteMajor(int value, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null.");
        OperationWrite.MAJOR.validate(this.beaconDevice);
        try {
            IBeaconPropertyValidator.validateMajor((int)value);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
        }
        Logger.d((String)String.format("Writing new major value - %s", String.valueOf(value)));
        try {
            this.overwrite(this.serviceStore.getMajorCharacteristic(), ConversionUtils.invert((byte[])ConversionUtils.to2ByteArray((int)value)), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteProximityUUID(UUID proximity, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null.");
        OperationWrite.PROXIMITY_UUID.validate(this.beaconDevice);
        try {
            SDKPreconditions.checkNotNull((Object)proximity);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getProximityCharacteristic(), ConversionUtils.convert((UUID)proximity), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwritePassword(String newPassword, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null.");
        OperationWrite.PASSWORD.validate(this.beaconDevice);
        try {
            IBeaconPropertyValidator.validateBeaconPassword((String)newPassword, (String)this.beaconDevice.getFirmwareVersion());
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getSetNewPasswordCharacteristic(), newPassword.getBytes(), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteModelName(String newModelName, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null.");
        OperationWrite.MODEL_NAME.validate(this.beaconDevice);
        try {
            IBeaconPropertyValidator.validateModelName((String)newModelName);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
            return;
        }
        byte[] modelNameBytes = newModelName.getBytes();
        Logger.d((String)String.format("Writing model Name - %s", newModelName));
        try {
            this.overwrite(this.serviceStore.getPropagatedDeviceNameCharacteristic(), modelNameBytes, writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteAdvertisingInterval(long millis, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"Write Listener is null.");
        OperationWrite.ADVERTISING_INTERVAL.validate(this.beaconDevice);
        try {
            IBeaconPropertyValidator.validateAdvertisingInterval((int)((int)millis));
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
            return;
        }
        Logger.d((String)String.format("Writing advertising interval - %s", String.valueOf(millis)));
        int value = Double.valueOf(Math.ceil((double)millis / 0.625)).intValue();
        try {
            this.overwrite(this.serviceStore.getAdvertisingIntervalCharacteristic(), ConversionUtils.invert((byte[])ConversionUtils.to2ByteArray((int)value)), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwritePowerLevel(int powerLevel, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null.");
        OperationWrite.POWER_LEVEL.validate(this.beaconDevice);
        try {
            IBeaconPropertyValidator.validatePowerLevel((int)powerLevel);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getPowerLevelCharacteristic(), ConversionUtils.convertPowerLevel((int)powerLevel), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void switchToDeviceProfile(DeviceProfile deviceProfile, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)deviceProfile, (Object)"DeviceProfile cannot be null");
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null.");
        OperationWrite.DEVICE_PROFILE.validate(this.beaconDevice);
        byte[] deviceProfileData = new byte[]{(byte)deviceProfile.getActiveProfileValue()};
        try {
            this.overwrite(this.serviceStore.getActiveProfileCharacteristic(), deviceProfileData, writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void resetDevice(WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null.");
        OperationWrite.RESET.validate(this.beaconDevice);
        Logger.d((String)"Resetting Beacon device...");
        try {
            this.overwrite(this.serviceStore.getResetCharacteristic(), new byte[]{1}, writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void enableDfuMode(String masterPassword, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null.");
        OperationWrite.DFU.validate(this.beaconDevice);
        try {
            IBeaconPropertyValidator.validateBeaconMasterPassword((String)masterPassword);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
        }
        try {
            this.overwrite(this.serviceStore.getBootloaderCharacteristic(), masterPassword.getBytes(), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteUrl(String newUrl, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null");
        OperationWrite.URL.validate(this.beaconDevice);
        try {
            EddystonePropertyValidator.validateUrl((String)newUrl);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
            return;
        }
        byte[] url = EddystoneUtils.serializeUrl((String)newUrl);
        try {
            this.overwrite(this.serviceStore.getUrlCharacteristic(), url, writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteNamespaceId(String namespaceId, WriteListener writeListener) {
        byte[] bytes;
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null");
        SDKPreconditions.checkNotNullOrEmpty((String)namespaceId, (String)"Namespace is null or empty");
        OperationWrite.NAMESPACE.validate(this.beaconDevice);
        try {
            EddystonePropertyValidator.validateHexString((String)namespaceId);
            bytes = EddystoneUtils.hexStringToByteArray((String)namespaceId);
            EddystonePropertyValidator.validateNamespace((byte[])bytes);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getNamespaceIdCharacteristic(), bytes, writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void overwriteInstanceId(String instanceId, WriteListener writeListener) {
        byte[] bytes;
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null");
        SDKPreconditions.checkNotNullOrEmpty((String)instanceId, (String)"Instance id is null or empty");
        OperationWrite.INSTANCE_ID.validate(this.beaconDevice);
        try {
            EddystonePropertyValidator.validateHexString((String)instanceId);
            bytes = EddystoneUtils.hexStringToByteArray((String)instanceId);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
            return;
        }
        try {
            EddystonePropertyValidator.validateHexString((String)instanceId);
            EddystonePropertyValidator.validateInstanceId((byte[])bytes);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getInstanceIdCharacteristic(), bytes, writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void restoreDefaultSettings(String masterPassword, WriteListener writeListener) {
        OperationWrite.RESTORE.validate(this.beaconDevice);
        Logger.d((String)"Restoring default settings to Beacon device...");
        try {
            IBeaconPropertyValidator.validateBeaconMasterPassword((String)masterPassword);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.INCORRECT_VALUE);
            return;
        }
        try {
            this.overwrite(this.serviceStore.getDefaultSettingsCharacteristic(), masterPassword.getBytes(), writeListener);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public synchronized void applySecureConfig(String secureConfig, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null");
        SDKPreconditions.checkNotNullOrEmpty((String)secureConfig, (String)"Secure config is null or empty");
        OperationWrite.SECURE_CONFIG.validate(this.beaconDevice);
        byte[] decodedConfig = Base64.decode((String)secureConfig, (int)0);
        try {
            this.overwriteSecure(this.serviceStore.getSecureWriteCharacteristic(), decodedConfig, writeListener, true);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @Override
    public void executeSecureCommand(String secureCommand, WriteListener writeListener) {
        SDKPreconditions.checkNotNull((Object)writeListener, (Object)"WriteListener is null");
        SDKPreconditions.checkNotNullOrEmpty((String)secureCommand, (String)"Secure command is null or empty");
        OperationWrite.SECURE_COMMAND.validate(this.beaconDevice);
        byte[] decodedCommand = Base64.decode((String)secureCommand, (int)0);
        try {
            this.overwriteSecure(this.serviceStore.getSecureWriteCharacteristic(), decodedCommand, writeListener, false);
        }
        catch (Exception e) {
            writeListener.onWriteFailure(WriteListener.Cause.FEATURE_NOT_SUPPORTED);
        }
    }

    @TargetApi(value=18)
    protected void overwrite(BluetoothGattCharacteristic characteristic, byte[] newValue, WriteListener listener) {
        SDKPreconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"The connection is closed");
        SDKPreconditions.checkState((boolean)this.isAuthenticated(), (Object)"The device is not authenticated");
        this.registerWriteListener(listener);
        byte[] currentValue = characteristic.getValue();
        characteristic.setValue(newValue);
        Logger.v((String)String.format("Writing value %s to characteristic %s", new String(newValue), characteristic.getUuid().toString()));
        if (!this.gattController.writeCharacteristic(characteristic)) {
            characteristic.setValue(currentValue);
            this.writeListener.onWriteFailure(WriteListener.Cause.GATT_FAILURE);
            this.unregisterWriteListener();
        }
    }

    @TargetApi(value=18)
    protected void overwriteSecure(BluetoothGattCharacteristic characteristic, byte[] newValue, WriteListener listener, boolean readResponse) {
        SDKPreconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"The connection is closed");
        SDKPreconditions.checkState((boolean)this.isAuthenticated(), (Object)"The device is not authenticated");
        this.registerWriteListener(listener);
        byte[] currentValue = characteristic.getValue();
        characteristic.setValue(newValue);
        Logger.v((String)String.format("Writing value %s to characteristic %s", new String(newValue), characteristic.getUuid().toString()));
        if (!this.gattController.writeCharacteristic(characteristic, readResponse)) {
            characteristic.setValue(currentValue);
            this.writeListener.onWriteFailure(WriteListener.Cause.GATT_FAILURE);
            this.unregisterWriteListener();
        }
    }

    State getState() {
        return this.state;
    }

    void finishWriteBatch() {
        this.unregisterWriteListener();
    }

    void onDisconnected() {
        this.serviceStore = null;
        this.connectionListener.onDisconnected();
    }

    void onDfuModeEnabled() {
    }

    void onServicesDiscovered(KontaktDeviceServiceStore serviceStore) {
        this.serviceStore = serviceStore;
    }

    void onAuthenticationSuccess(RemoteBluetoothDevice.Characteristics deviceCharacteristics) {
        this.connectionListener.onAuthenticationSuccess(deviceCharacteristics);
    }

    void onError(int errorCode) {
        this.connectionListener.onErrorOccured(errorCode);
    }

    void onFailure(int failureCode) {
        this.connectionListener.onAuthenticationFailure(failureCode);
    }

    void onConnectionStateChange(State state) {
        this.state = state;
    }

    void onCharacteristicWritten(boolean isSuccess, WriteListener.WriteResponse response) {
        if (isSuccess) {
            this.writeListener.onWriteSuccess(response);
        } else {
            this.writeListener.onWriteFailure(WriteListener.Cause.GATT_FAILURE);
        }
    }

    void onConnected() {
        this.connectionListener.onConnected();
    }

    void notifyDataSetChanged() {
        this.connectionListener.onCharacteristicsUpdated(new KontaktDeviceCharacteristics(this.serviceStore));
    }

    private void registerWriteListener(WriteListener writeListener) {
        this.writeListener = writeListener;
    }

    private void unregisterWriteListener() {
        this.writeListener = WriteListener.NULL_LISTENER;
    }

    private Context getContext() {
        return this.context;
    }

    private void validateBeaconPassword(RemoteBluetoothDevice remoteBluetoothDevice) {
        if (FirmwareRevisions.NORMAL_MODE_FIRMWARE_VERSIONS.contains(remoteBluetoothDevice.getFirmwareVersion())) {
            SDKPreconditions.checkNotNull((Object)remoteBluetoothDevice.getPassword(), (Object)"Beacon password is null or empty.");
            IBeaconPropertyValidator.validateBeaconPassword((String)new String(remoteBluetoothDevice.getPassword()), (String)remoteBluetoothDevice.getFirmwareVersion());
        }
    }

    private static <T> KontaktDeviceBatchProcessor.ProcessingListener createProcessingListener(final T batchHolder, final WriteBatchListener<T> writeBatchListener) {
        return new KontaktDeviceBatchProcessor.ProcessingListener(){

            @Override
            public void onStart() {
                writeBatchListener.onWriteBatchStart(batchHolder);
            }

            @Override
            public void onError(int errorCode) {
                writeBatchListener.onErrorOccured(errorCode);
            }

            @Override
            public void onFinish() {
                writeBatchListener.onWriteBatchFinish(batchHolder);
            }

            @Override
            public void onRollbackStart() {
            }

            @Override
            public void onRollbackFinish() {
            }

            @Override
            public void onRollbackError(int errorCode) {
            }
        };
    }

    public static enum State {
        CONNECTED,
        AUTHENTICATING,
        CHARACTERISTICS_REQUESTING,
        AUTHENTICATED,
        DISCONNECTED;

    }
}

