package com.kontakt.sdk.android.ble.spec;

import com.kontakt.sdk.android.ble.exception.CharacteristicAbsentException;
import com.kontakt.sdk.android.ble.exception.ServiceAbsentException;

public interface GattServiceStore {

    BluetoothDeviceCharacteristic getFirmwareRevisionCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getHardwareRevisionCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getManufacturerNameCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getDeviceNameCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getPropagatedDeviceNameCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getMinorCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getNonConnectableCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getShuffleIntervalCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getShuffleKeyCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getSensorOnCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getAccelerometerCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getActiveProfileCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getMajorCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getProximityCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getPowerLevelCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getBatteryLevelCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getPasswordCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getMasterPasswordCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getSetNewPasswordCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getAdvertisingIntervalCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getResetCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getBootloaderCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getUniqueIdCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getNamespaceIdCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getInstanceIdCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getUrlCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getDefaultSettingsCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getSecureLastProcessedRequestTokenCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getSecureWriteCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getSecureResponseCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    BluetoothDeviceCharacteristic getSecureControlPointCharacteristic() throws ServiceAbsentException, CharacteristicAbsentException;

    boolean contains(KontaktDeviceService serviceModel);

    void replace(BluetoothDeviceCharacteristic characteristic) throws ServiceAbsentException;

    void clear();
}
