package com.kontakt.sdk.android.ble.service;

import com.kontakt.sdk.android.ble.configuration.scan.ScanContext;
import com.kontakt.sdk.android.ble.manager.ProximityManager;

import java.io.Closeable;
import java.io.IOException;

interface ScanConfiguration extends ListenerCollector, Closeable {

    BleScanCallback getScanCallback();

    ScanContext getScanContext();

    ScanConfiguration NULL = new ScanConfiguration() {
        @Override
        public BleScanCallback getScanCallback() {
            return BleScanCallback.DEFAULT;
        }

        @Override
        public ScanContext getScanContext() {
            return ScanContext.DEFAULT;
        }

        @Override
        public void close() throws IOException {

        }

        @Override
        public void addListener(ProximityManager.ProximityListener proximityListener) {

        }

        @Override
        public void removeListener(ProximityManager.ProximityListener proximityListener) {

        }
    };
}
