package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.os.Build;

import com.kontakt.sdk.android.common.util.SDKPreconditions;

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
final class CallbacksL {
    private CallbacksL() { }

    static BleScanCallback newCallback(final BluetoothAdapter.LeScanCallback wrappedScanCallback) {
        SDKPreconditions.checkState(wrappedScanCallback instanceof MonitorCallback, "Scan callback must extend MonitorCallback");
        return new MonitorCallbackL((MonitorCallback) wrappedScanCallback) { };
    }
}
