package com.kontakt.sdk.android.ble.rssi;

import com.kontakt.sdk.android.common.util.SDKPreconditions;
/**
 * RssiCalculators provides factory methods for predefined
 * Rssi calculators.
 */
public final class RssiCalculators {

    private RssiCalculators() { }

    private static final int MAX_LOG_SIZE = 10;

    /**
     * Default Rssi Calculator provides no rssi calculation logic.
     */
    public static final RssiCalculator DEFAULT = new RssiCalculator() {
        @Override
        public double calculateRssi(int uniqueKey, int rssi) {
            return rssi;
        }

        @Override
        public void clear() {

        }

        @Override
        public void clear(int uniqueKey) {

        }
    };

    /**
     * Creates new limited mean Rssi Calculator.
     *
     * @param logLimit the log limit
     * @return the limited mean rssi calculator
     */
    public static LimitedMeanRssiCalculator newLimitedMeanRssiCalculator(final int logLimit) {
        SDKPreconditions.checkArgument(logLimit > 0 && logLimit <= MAX_LOG_SIZE,
                "Rssi Mean limit should be a value within range (0, 10]");
        return new LimitedMeanRssiCalculator(logLimit);
    }
}
