package com.kontakt.sdk.android.ble.filter.ibeacon;

import com.kontakt.sdk.android.ble.discovery.ibeacon.IBeaconAdvertisingPacket;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

/**
 * A predicate accepting iBeacon devices with specific unique ID.
 */
public final class IBeaconUniqueIdFilter implements IBeaconFilter {

    private final String beaconUniqueId;

    public IBeaconUniqueIdFilter(final String beaconUniqueId) {
        SDKPreconditions.checkNotNull(beaconUniqueId, "Beacon unique id is null");
        this.beaconUniqueId = beaconUniqueId;
    }

    @Override
    public boolean apply(IBeaconAdvertisingPacket controller) {
        final String uniqueId = controller.getBeaconUniqueId();
        return uniqueId != null && beaconUniqueId.equals(uniqueId);
    }

    /**
     * Provides beacon unique id.
     *
     * @return the beacon unique id
     */
    public String getBeaconUniqueId() {
        return beaconUniqueId;
    }
}