package com.kontakt.sdk.android.ble.filter.eddystone;

import com.android.internal.util.Predicate;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneURLAdvertisingPacket;

/**
 * Filters are designed to enable more detailed devices search and thus reduce battery consumption.
 *
 * A predicate accepting Eddystone-specific URL advertising packet
 *
 * The URL advertising packet has the following structure:
 * [0] - url prefix
 * [1]...[n] - url length
 */
public interface URLFilter extends Predicate<EddystoneURLAdvertisingPacket> {
}
