package com.kontakt.sdk.android.ble.filter.eddystone;

import com.android.internal.util.Predicate;
import com.kontakt.sdk.android.ble.discovery.eddystone.EddystoneTLMAdvertisingPacket;

/**
 * Filters are designed to enable more detailed devices search and thus reduce battery consumption.
 *
 * Predicate accepting Eddystone's specific TLM byte frame.
 * The TLM advertising packet has the following structure:
 *<ul>
 *     <li>[0] - TLM version</li>
 *     <li>[1]..[2] - battery voltage</li>
 *     <li>[3]..[4] - beacon temperature</li>
 *     <li>[5]..[8] - Advertising PDU Count</li>
 *     <li>[9]..[12] - Second resolution counter</li>
 *</ul>
 */
public interface TLMFilter extends Predicate<EddystoneTLMAdvertisingPacket> {
}
