package com.kontakt.sdk.android.ble.discovery.ibeacon;

import com.kontakt.sdk.android.ble.device.BeaconRegion;
import com.kontakt.sdk.android.ble.discovery.Validator;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;

final class RegionValidator implements Validator<IBeaconAdvertisingPacket, IBeaconRegion> {

    @Override
    public boolean isValid(IBeaconAdvertisingPacket iBeaconAdvertisingPacket, IBeaconRegion iBeaconRegion) {
        if(iBeaconRegion == BeaconRegion.EVERYWHERE) {
            return true;
        }

        if(iBeaconAdvertisingPacket.getProximityUUID().equals(iBeaconRegion.getProximity())){

            if (iBeaconRegion.getMajor() != BeaconRegion.ANY_MAJOR && iBeaconRegion.getMinor() != BeaconRegion.ANY_MINOR) {
                return iBeaconAdvertisingPacket.getMajor() == iBeaconRegion.getMajor()
                        && iBeaconAdvertisingPacket.getMinor() == iBeaconRegion.getMinor();
            }

            if (iBeaconRegion.getMajor() == BeaconRegion.ANY_MAJOR && iBeaconRegion.getMinor() != BeaconRegion.ANY_MINOR) {
                return iBeaconAdvertisingPacket.getMinor() == iBeaconRegion.getMinor();
            }

            if (iBeaconRegion.getMajor() != BeaconRegion.ANY_MAJOR && iBeaconRegion.getMinor() == BeaconRegion.ANY_MINOR) {
                return iBeaconAdvertisingPacket.getMajor() == iBeaconRegion.getMajor();
            }

            if (iBeaconRegion.getMajor() == BeaconRegion.ANY_MAJOR && iBeaconRegion.getMinor() == BeaconRegion.ANY_MINOR) {
                return true;
            }

        }

        return false;
    }
}
