package com.kontakt.sdk.android.ble.discovery;

import com.kontakt.sdk.android.ble.configuration.ActivityCheckConfiguration;

/**
 * Describes event type notified via {@link com.kontakt.sdk.android.ble.manager.ProximityManager.ProximityListener#onEvent(BluetoothDeviceEvent)}.
 */
public enum EventType {
    /**
     * Called as a first event whenever Android device enters new space.
     * The event with this type should contain Space representation with empty devices list.
     */
    SPACE_ENTERED,
    /**
     * Called after {@link #SPACE_ENTERED}. The event with this type should contain
     * Space representation with devices list containing exactly one newly discovered device.
     */
    DEVICE_DISCOVERED,
    /**
     * Called after {@link #DEVICE_DISCOVERED}. The event with this type should contain
     * Space representation with already discovered devices with updated parameters.
     * This type is notified very often once the Android device receives signals from many
     * devices nearby. To make the event with this type occuring with interval, please
     * specify devicesUpdateCallbackInterval parameter that you can set via
     * {@link com.kontakt.sdk.android.ble.configuration.scan.IBeaconScanContext.Builder#setDevicesUpdateCallbackInterval(long)}
     * or via
     * {@link com.kontakt.sdk.android.ble.configuration.scan.EddystoneScanContext.Builder#setDevicesUpdateCallbackInterval(long)}.
     */
    DEVICES_UPDATE,
    /**
     * Called after {@link #DEVICES_UPDATE}. The event with this type should contain
     * Space representation with one device from which the Android device has not
     * received signal for the period described by {@link ActivityCheckConfiguration#getInactivityTimeout()}
     */
    DEVICE_LOST,
    /**
     * Called after {@link #DEVICE_LOST} when there are no devices belonging to
     * the specific space. The event with this type should contain Space representation
     * with no devices devices list.
     */
    SPACE_ABANDONED,
}
