package com.kontakt.sdk.android.ble.device;

import android.os.Bundle;
import android.os.Parcel;

import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.Constants;

/**
 * {@link IEddystoneNamespace} implementation.
 */
public class EddystoneNamespace implements IEddystoneNamespace {

    /**
     * Predefined constant specifying that every visible remote Eddystone device should be notified
     * by Android device regardless of its belonging to the specific namespace.
     */
    public static EddystoneNamespace EVERYWHERE = new EddystoneNamespace("Everywhere", "");

    /**
     * The constant CREATOR.
     */
    public static final Creator<EddystoneNamespace> CREATOR = new Creator<EddystoneNamespace>() {
        @Override
        public EddystoneNamespace createFromParcel(Parcel source) {
            Bundle bundle = source.readBundle(getClass().getClassLoader());

            return new EddystoneNamespace(
                    bundle.getString("name"),
                    bundle.getString(Constants.Eddystone.URL)
            );
        }

        @Override
        public EddystoneNamespace[] newArray(int size) {
            return new EddystoneNamespace[size];
        }
    };

    private final String name;
    private final String namespaceId;
    private final int hashCode;

    /**
     * Instantiates a new Eddystone namespace.
     *
     * @param name the name
     * @param namespaceId the namespace id
     */
    public EddystoneNamespace(String name, String namespaceId) {
        this.namespaceId = namespaceId;
        this.name = name;
        this.hashCode = namespaceId.hashCode();
    }

    @Override
    public String getId() {
        return namespaceId;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) {
            return true;
        }

        if(o == null || !(o instanceof EddystoneNamespace)) {
            return false;
        }

        final EddystoneNamespace eddystoneNamespace = (EddystoneNamespace) o;

        return namespaceId.equals(eddystoneNamespace.namespaceId);
    }

    @Override
    public int compareTo(IEddystoneNamespace another) {
        if(this == another) {
            return 0;
        }

        return namespaceId.compareTo(another.getId());
    }

    @Override
    public int hashCode() {
        return hashCode;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle(getClass().getClassLoader());
        bundle.putString(Constants.Eddystone.URL, namespaceId);
        bundle.putString("name", name);

        dest.writeBundle(bundle);
    }
}
