package com.kontakt.sdk.android.ble.connection;

/**
 * WriteBatchListener provides callback methods notifying about writing parameters batch to Beacon device.
 *
 * @param <T> Batch holder type
 */
public interface WriteBatchListener<T> {
    /**
     * Informs that Android device starts writing parameters Batch to Beacon device.
     *
     * @param batchHolder the batch holder
     */
    void onWriteBatchStart(T batchHolder);

    /**
     * Informs that Android device finishes writing parameters Batch to Beacon device.
     *
     * @param batchHolder the batch holder
     */
    void onWriteBatchFinish(T batchHolder);

    /**
     * Informs that an error has occured during batch write operation.
     * Once the callback method is launched the rollback operation is performed aiming at
     * restoring original configuration to Beacon device.
     *
     * @param errorCode the error code
     */
    void onErrorOccured(int errorCode);

    /**
     * Notifies the failure occured during writing parameters batch to iBeacon device.
     */
    void onWriteFailure();
}
