package com.kontakt.sdk.android.ble.broadcast;

/**
 * The listener notifying about Bluetooth state change.
 * The listener is accepted by {@link BluetoothStateChangeReceiver}.
 */
public interface OnBluetoothStateChangeListener {
    /**
     * Bluetooth is connecting.
     */
    void onBluetoothConnecting();

    /**
     * Bluetooth is connected.
     */
    void onBluetoothConnected();

    /**
     * Bluetooth is disconnecting.
     */
    void onBluetoothDisconnecting();

    /**
     * Bluetooth is disconnected.
     */
    void onBluetoothDisconnected();
}
