/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;

public class MaxRelativeLayout
extends RelativeLayout {
    private int maxWidth;
    private int maxHeight;
    private int minWidth;
    private int minHeight;
    private boolean lockWidth;
    private boolean interceptTouch = true;
    private View contentView;
    private float startAnimValue = 0.0f;
    private float endAnimValue = 0.0f;
    private ScrollView childScrollView;
    private int preWidth = -1;
    private OnYChanged onYChangedListener;
    int navBarHeight;
    Paint navBarPaint;
    private View.OnTouchListener onTouchListener;
    boolean reInterceptTouch;

    public MaxRelativeLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaxRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MaxRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DialogXMaxLayout);
            this.maxWidth = a.getDimensionPixelSize(R.styleable.DialogXMaxLayout_maxLayoutWidth, 0);
            this.maxHeight = a.getDimensionPixelSize(R.styleable.DialogXMaxLayout_maxLayoutHeight, 0);
            this.minWidth = a.getDimensionPixelSize(R.styleable.DialogXMaxLayout_minLayoutWidth, 0);
            this.minHeight = a.getDimensionPixelSize(R.styleable.DialogXMaxLayout_minLayoutHeight, 0);
            this.lockWidth = a.getBoolean(R.styleable.DialogXMaxLayout_lockWidth, false);
            this.interceptTouch = a.getBoolean(R.styleable.DialogXMaxLayout_interceptTouch, true);
            a.recycle();
        }
        this.minWidth = this.minWidth == 0 ? this.getMinimumWidth() : this.minWidth;
        int n = this.minHeight = this.minHeight == 0 ? this.getMinimumHeight() : this.minHeight;
        if (!this.isInEditMode() && Build.VERSION.SDK_INT >= 19) {
            this.animate().setUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float progress = ((Float)animation.getAnimatedValue()).floatValue();
                    long value = (long)(MaxRelativeLayout.this.startAnimValue + (MaxRelativeLayout.this.endAnimValue - MaxRelativeLayout.this.startAnimValue) * progress);
                    if (MaxRelativeLayout.this.onYChangedListener != null) {
                        MaxRelativeLayout.this.onYChangedListener.y(value);
                    }
                }
            });
        }
    }

    public MaxRelativeLayout setMaxHeight(int maxHeight) {
        if (maxHeight > 0) {
            this.maxHeight = maxHeight;
        }
        return this;
    }

    public MaxRelativeLayout setMaxWidth(int maxWidth) {
        if (maxWidth > 0) {
            this.maxWidth = maxWidth;
        }
        return this;
    }

    public void setMinHeight(int minHeight) {
        if (minHeight > 0) {
            this.minHeight = minHeight;
        }
    }

    public void setMinWidth(int minWidth) {
        if (minWidth > 0) {
            this.minWidth = minWidth;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View contentView;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.preWidth == -1 && widthSize != 0) {
            this.preWidth = widthSize;
        }
        if (this.lockWidth) {
            this.maxWidth = Math.min(this.maxWidth, Math.min(widthSize, this.preWidth));
        }
        if (heightSize > this.maxHeight && this.maxHeight != 0) {
            heightSize = this.maxHeight + this.getPaddingBottom() + this.getPaddingTop();
        }
        if (widthSize > this.maxWidth && this.maxWidth != 0) {
            widthSize = this.maxWidth + this.getPaddingLeft() + this.getPaddingRight();
        }
        View blurView = this.findViewWithTag("blurView");
        View view = contentView = this.contentView == null ? this.findViewWithoutTag("blurView") : this.contentView;
        if (contentView != null && blurView != null) {
            int heightTemp;
            int widthTemp = contentView.getMeasuredWidth() == 0 ? this.getMeasuredWidth() : contentView.getMeasuredWidth();
            int n = heightTemp = contentView.getMeasuredHeight() == 0 ? this.getMeasuredHeight() : contentView.getMeasuredHeight();
            if (widthTemp < this.minWidth) {
                widthTemp = this.minWidth;
            }
            if (heightTemp < this.minHeight) {
                heightTemp = this.minHeight;
            }
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)blurView.getLayoutParams();
            lp.addRule(13);
            lp.width = widthTemp;
            lp.height = heightTemp;
            blurView.setLayoutParams((ViewGroup.LayoutParams)lp);
        } else if (blurView != null) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)blurView.getLayoutParams();
            lp.width = this.getMeasuredWidth();
            lp.height = this.getMeasuredHeight();
            blurView.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        int maxHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
        int maxWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode);
        super.onMeasure(maxWidthMeasureSpec, maxHeightMeasureSpec);
        this.childScrollView = (ScrollView)this.findViewById(R.id.scrollView);
    }

    private View findViewWithoutTag(String tag) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (tag.equals(this.getChildAt(i).getTag())) continue;
            return this.getChildAt(i);
        }
        return null;
    }

    @Deprecated
    public boolean isChildScrollViewCanScroll() {
        if (this.childScrollView == null) {
            return false;
        }
        if (!this.childScrollView.isEnabled()) {
            return false;
        }
        View child = this.childScrollView.getChildAt(0);
        if (child != null) {
            int childHeight = child.getHeight();
            return this.childScrollView.getHeight() < childHeight;
        }
        return false;
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public boolean isLockWidth() {
        return this.lockWidth;
    }

    public MaxRelativeLayout setLockWidth(boolean lockWidth) {
        this.lockWidth = lockWidth;
        return this;
    }

    public void setNavBarHeight(int height) {
        this.navBarHeight = height;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.navBarHeight != 0 && DialogX.bottomDialogNavbarColor != 0) {
            if (this.navBarPaint == null) {
                this.navBarPaint = new Paint();
                this.navBarPaint.setColor(DialogX.bottomDialogNavbarColor);
            }
            canvas.drawRect(0.0f, (float)(this.getHeight() - this.navBarHeight), (float)this.getWidth(), (float)this.getHeight(), this.navBarPaint);
        }
    }

    public void setContentView(View contentView) {
        this.contentView = contentView;
    }

    public void setY(float y) {
        super.setY(y);
    }

    public OnYChanged getOnYChanged() {
        return this.onYChangedListener;
    }

    public MaxRelativeLayout setOnYChanged(OnYChanged onYChanged) {
        this.onYChangedListener = onYChanged;
        return this;
    }

    public void setTranslationY(float translationY) {
        super.setTranslationY(translationY);
        if (this.onYChangedListener != null) {
            this.onYChangedListener.y(translationY);
        }
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.onTouchListener = l;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.onTouchListener != null) {
            this.reInterceptTouch = this.onTouchListener.onTouch((View)this, ev);
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.reInterceptTouch;
    }

    public static interface OnYChanged {
        public void y(float var1);
    }
}

