/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.appcompat.view.ContextThemeWrapper;
import com.kongzue.dialogx.dialogs.BottomDialog;
import com.kongzue.dialogx.interfaces.BottomMenuListViewTouchEvent;

public class BottomDialogListView
extends ListView {
    private BottomMenuListViewTouchEvent bottomMenuListViewTouchEvent;
    private BottomDialog.DialogImpl dialogImpl;
    private int mPosition;
    private float touchDownY;
    private int size = 1;

    public BottomDialogListView(Context context) {
        super(context);
    }

    public BottomDialogListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BottomDialogListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public BottomDialogListView(BottomDialog.DialogImpl dialog, Context context) {
        super(context);
        this.dialogImpl = dialog;
        this.setVerticalScrollBarEnabled(false);
    }

    public BottomDialogListView(BottomDialog.DialogImpl dialog, Context context, int theme) {
        super((Context)new ContextThemeWrapper(context, theme));
        this.dialogImpl = dialog;
        this.setVerticalScrollBarEnabled(false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int expandSpec = View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE);
        super.onMeasure(widthMeasureSpec, expandSpec);
    }

    private int dip2px(float dpValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int actionMasked = ev.getActionMasked() & 0xFF;
        if (actionMasked == 0) {
            this.touchDownY = ev.getY();
            if (this.bottomMenuListViewTouchEvent != null) {
                this.bottomMenuListViewTouchEvent.down(ev);
            }
            this.mPosition = this.pointToPosition((int)ev.getX(), (int)ev.getY());
            return super.dispatchTouchEvent(ev);
        }
        if (actionMasked == 2) {
            if (this.bottomMenuListViewTouchEvent != null) {
                this.bottomMenuListViewTouchEvent.move(ev);
            }
            if (Math.abs(this.touchDownY - ev.getY()) > (float)this.dip2px(5.0f)) {
                ev.setAction(3);
                this.dispatchTouchEvent(ev);
                return false;
            }
            return true;
        }
        if (actionMasked == 1 || actionMasked == 3) {
            if (this.bottomMenuListViewTouchEvent != null) {
                this.bottomMenuListViewTouchEvent.up(ev);
            }
            if (this.pointToPosition((int)ev.getX(), (int)ev.getY()) == this.mPosition) {
                super.dispatchTouchEvent(ev);
            } else {
                this.setPressed(false);
                this.invalidate();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public BottomMenuListViewTouchEvent getBottomMenuListViewTouchEvent() {
        return this.bottomMenuListViewTouchEvent;
    }

    public void setAdapter(ListAdapter adapter) {
        this.size = adapter.getCount();
        super.setAdapter(adapter);
    }

    public BottomDialogListView setBottomMenuListViewTouchEvent(BottomMenuListViewTouchEvent bottomMenuListViewTouchEvent) {
        this.bottomMenuListViewTouchEvent = bottomMenuListViewTouchEvent;
        return this;
    }
}

