/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewTreeObserver;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.renderscript.Allocation;
import androidx.renderscript.Element;
import androidx.renderscript.RenderScript;
import androidx.renderscript.ScriptIntrinsicBlur;
import androidx.renderscript.Type;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;

@Deprecated
public class BlurView
extends View {
    private float mDownsampleFactor = 4.0f;
    private int mOverlayColor = -1;
    private float mBlurRadius = 35.0f;
    private boolean overrideOverlayColor = false;
    private float mRadius = 0.0f;
    private boolean mDirty;
    private Bitmap mBitmapToBlur;
    private Bitmap mBlurredBitmap;
    private Canvas mBlurringCanvas;
    private RenderScript mRenderScript;
    private ScriptIntrinsicBlur mBlurScript;
    private Allocation mBlurInput;
    private Allocation mBlurOutput;
    private boolean mIsRendering;
    private final Rect mRectSrc = new Rect();
    private final Rect mRectDst = new Rect();
    private View mDecorView;
    private boolean mDifferentRoot;
    private static int RENDERING_COUNT;
    private Paint mPaint;
    private RectF mRectF;
    private boolean isInit = false;
    Paint cutPaint;
    Paint overlayPaint;
    private final ViewTreeObserver.OnPreDrawListener preDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onPreDraw() {
            int[] locations = new int[2];
            Bitmap oldBmp = BlurView.this.mBlurredBitmap;
            View decor = BlurView.this.mDecorView;
            if (decor != null && BlurView.this.isShown() && BlurView.this.prepare()) {
                boolean redrawBitmap = BlurView.this.mBlurredBitmap != oldBmp;
                decor.getLocationInWindow(locations);
                int x = -locations[0];
                int y = -locations[1];
                BlurView.this.getLocationInWindow(locations);
                x += locations[0];
                y += locations[1];
                BlurView.this.mBitmapToBlur.eraseColor(BlurView.this.mOverlayColor & 0xFFFFFF);
                int rc = BlurView.this.mBlurringCanvas.save();
                BlurView.this.mIsRendering = true;
                RENDERING_COUNT++;
                try {
                    BlurView.this.mBlurringCanvas.scale(1.0f * (float)BlurView.this.mBitmapToBlur.getWidth() / (float)BlurView.this.getWidth(), 1.0f * (float)BlurView.this.mBitmapToBlur.getHeight() / (float)BlurView.this.getHeight());
                    BlurView.this.mBlurringCanvas.translate((float)(-x), (float)(-y));
                    if (decor.getBackground() != null) {
                        decor.getBackground().draw(BlurView.this.mBlurringCanvas);
                    }
                    decor.draw(BlurView.this.mBlurringCanvas);
                }
                catch (Exception e) {
                    if (BlurView.isDebug()) {
                        e.printStackTrace();
                    }
                }
                finally {
                    BlurView.this.mIsRendering = false;
                    RENDERING_COUNT--;
                    BlurView.this.mBlurringCanvas.restoreToCount(rc);
                }
                BlurView.this.blur(BlurView.this.mBitmapToBlur, BlurView.this.mBlurredBitmap);
                if (redrawBitmap || BlurView.this.mDifferentRoot) {
                    BlurView.this.invalidate();
                }
            }
            return true;
        }
    };
    private static boolean supportRenderScript;
    private boolean useBlur = true;
    public static boolean DEBUGMODE;

    public BlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public BlurView(Context context) {
        super(context);
        this.init(context, null);
    }

    public BlurView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (!this.isInit && context != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RealtimeBlurView);
            this.mBlurRadius = a.getDimension(R.styleable.RealtimeBlurView_realtimeBlurRadius, TypedValue.applyDimension((int)1, (float)35.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
            this.mDownsampleFactor = a.getFloat(R.styleable.RealtimeBlurView_realtimeDownsampleFactor, 4.0f);
            this.mOverlayColor = a.getColor(R.styleable.RealtimeBlurView_realtimeOverlayColor, 0xFFFFFF);
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mRectF = new RectF();
            this.cutPaint = new Paint();
            this.cutPaint.setAntiAlias(true);
            this.cutPaint.setColor(this.mOverlayColor);
            this.overlayPaint = new Paint();
            this.overlayPaint.setAntiAlias(true);
            this.mRadius = a.getDimension(R.styleable.RealtimeBlurView_realtimeRadius, TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
            a.recycle();
            this.isInit = true;
            if (!this.isCompatMode()) {
                this.setOutlineProvider(new ViewOutlineProvider(){

                    public void getOutline(View view, Outline outline) {
                        outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), BlurView.this.mRadius);
                    }
                });
                this.setClipToOutline(true);
            }
        }
    }

    private boolean isCompatMode() {
        return Build.VERSION.SDK_INT < 21;
    }

    public void setBlurRadius(float radius) {
        if (this.mBlurRadius != radius) {
            this.mBlurRadius = radius;
            this.mDirty = true;
            this.invalidate();
        }
    }

    public void setRadiusPx(float r) {
        if (this.mRadius != r) {
            this.mRadius = r;
            this.mDirty = true;
            this.invalidate();
        }
    }

    public void setDownsampleFactor(float factor) {
        if (factor <= 0.0f) {
            throw new IllegalArgumentException("Downsample factor must be greater than 0.");
        }
        if (this.mDownsampleFactor != factor) {
            this.mDownsampleFactor = factor;
            this.mDirty = true;
            this.releaseBitmap();
            this.invalidate();
        }
    }

    public void setOverlayColor(int color2) {
        if (this.mOverlayColor != color2) {
            this.mOverlayColor = color2;
            this.invalidate();
        }
    }

    private void releaseBitmap() {
        if (this.mBlurInput != null) {
            this.mBlurInput.destroy();
            this.mBlurInput = null;
        }
        if (this.mBlurOutput != null) {
            this.mBlurOutput.destroy();
            this.mBlurOutput = null;
        }
        if (this.mBitmapToBlur != null) {
            this.mBitmapToBlur.recycle();
            this.mBitmapToBlur = null;
        }
        if (this.mBlurredBitmap != null) {
            this.mBlurredBitmap.recycle();
            this.mBlurredBitmap = null;
        }
    }

    private void releaseScript() {
        if (this.mRenderScript != null) {
            this.mRenderScript.destroy();
            this.mRenderScript = null;
        }
        if (this.mBlurScript != null) {
            this.mBlurScript.destroy();
            this.mBlurScript = null;
        }
    }

    protected void release() {
        this.releaseBitmap();
        this.releaseScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepare() {
        block21: {
            if (this.mBlurRadius == 0.0f) {
                this.release();
                return false;
            }
            float downsampleFactor = this.mDownsampleFactor;
            if ((this.mDirty || this.mRenderScript == null) && supportRenderScript && this.useBlur) {
                block20: {
                    if (this.mRenderScript == null) {
                        try {
                            this.mRenderScript = RenderScript.create((Context)this.getContext());
                            this.mBlurScript = ScriptIntrinsicBlur.create((RenderScript)this.mRenderScript, (Element)Element.U8_4((RenderScript)this.mRenderScript));
                        }
                        catch (Exception e) {
                            supportRenderScript = false;
                            if (!BlurView.isDebug()) break block20;
                            e.printStackTrace();
                        }
                    }
                }
                this.mDirty = false;
                float radius = this.mBlurRadius / downsampleFactor;
                if (radius > 25.0f) {
                    downsampleFactor = downsampleFactor * radius / 25.0f;
                    radius = 25.0f;
                }
                if (this.mBlurScript != null) {
                    this.mBlurScript.setRadius(radius);
                }
            }
            int width = this.getWidth();
            int height = this.getHeight();
            int scaledWidth = Math.max(1, (int)((float)width / downsampleFactor));
            int scaledHeight = Math.max(1, (int)((float)height / downsampleFactor));
            if (this.mBlurringCanvas == null || this.mBlurredBitmap == null || this.mBlurredBitmap.getWidth() != scaledWidth || this.mBlurredBitmap.getHeight() != scaledHeight) {
                this.releaseBitmap();
                boolean r = false;
                try {
                    this.mBitmapToBlur = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    if (this.mBitmapToBlur == null) {
                        boolean bl = false;
                        return bl;
                    }
                    this.mBlurringCanvas = new Canvas(this.mBitmapToBlur);
                    if (!supportRenderScript || !this.useBlur) {
                        boolean bl = true;
                        return bl;
                    }
                    this.mBlurInput = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)this.mBitmapToBlur, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
                    this.mBlurOutput = Allocation.createTyped((RenderScript)this.mRenderScript, (Type)this.mBlurInput.getType());
                    this.mBlurredBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    if (this.mBlurredBitmap == null) {
                        boolean bl = false;
                        return bl;
                    }
                    r = true;
                }
                catch (Exception e) {
                    if (BlurView.isDebug()) {
                        e.printStackTrace();
                    }
                }
                finally {
                    if (r) break block21;
                    this.releaseBitmap();
                    return false;
                }
            }
        }
        return true;
    }

    protected void blur(Bitmap bitmapToBlur, Bitmap blurredBitmap) {
        this.mBlurInput.copyFrom(bitmapToBlur);
        this.mBlurScript.setInput(this.mBlurInput);
        this.mBlurScript.forEach(this.mBlurOutput);
        this.mBlurOutput.copyTo(blurredBitmap);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        BlurView.log(this.getContext());
        Activity activity = this.getContext() instanceof Activity ? (Activity)this.getContext() : BaseDialog.getTopActivity();
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        if (decorView.getChildCount() >= 1) {
            this.mDecorView = decorView.getChildAt(0);
        }
        if (this.mDecorView != null) {
            BlurView.log("mDecorView is ok.");
            this.mDecorView.getViewTreeObserver().addOnPreDrawListener(this.preDrawListener);
            boolean bl = this.mDifferentRoot = this.mDecorView.getRootView() != this.getRootView();
            if (this.mDifferentRoot) {
                this.mDecorView.postInvalidate();
            }
        } else {
            BlurView.log("mDecorView is NULL.");
            this.mDifferentRoot = false;
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mDecorView != null) {
            this.mDecorView.getViewTreeObserver().removeOnPreDrawListener(this.preDrawListener);
        }
        this.release();
        super.onDetachedFromWindow();
    }

    public void draw(Canvas canvas) {
        if (!this.useBlur || !supportRenderScript) {
            this.mRectF.right = this.getWidth();
            this.mRectF.bottom = this.getHeight();
            this.overlayPaint.setColor(this.needRemoveAlphaColor() ? BlurView.removeAlphaColor(this.mOverlayColor) : this.mOverlayColor);
            canvas.drawRoundRect(this.mRectF, this.mRadius, this.mRadius, this.overlayPaint);
        } else if (!this.mIsRendering && RENDERING_COUNT <= 0) {
            super.draw(canvas);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isCompatMode()) {
            this.drawBlurredBitmapCompat(canvas);
        } else {
            this.drawBlurredBitmap(canvas, this.mBlurredBitmap);
        }
    }

    private void drawBlurredBitmapCompat(Canvas canvas) {
        if (this.mBlurredBitmap != null) {
            this.mRectDst.right = this.getWidth();
            this.mRectDst.bottom = this.getHeight();
            if (this.getWidth() > 0 && this.getHeight() > 0) {
                Bitmap readyDrawBitmap = this.getRoundedCornerBitmap(this.resizeImage(this.mBlurredBitmap, this.getWidth(), this.getHeight()), this.mRectDst);
                if (readyDrawBitmap != null) {
                    canvas.drawBitmap(readyDrawBitmap, 0.0f, 0.0f, null);
                } else {
                    Bitmap overlyBitmap = this.drawOverlyColor(Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888));
                    if (overlyBitmap != null) {
                        canvas.drawBitmap(overlyBitmap, 0.0f, 0.0f, null);
                    }
                }
            }
        } else {
            Bitmap overlyBitmap = this.drawOverlyColor(Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888));
            if (overlyBitmap != null) {
                canvas.drawBitmap(overlyBitmap, 0.0f, 0.0f, null);
            }
        }
    }

    protected void drawBlurredBitmap(Canvas canvas, Bitmap blurredBitmap) {
        if (blurredBitmap != null) {
            this.mRectSrc.right = blurredBitmap.getWidth();
            this.mRectSrc.bottom = blurredBitmap.getHeight();
            this.mRectDst.right = this.getWidth();
            this.mRectDst.bottom = this.getHeight();
            canvas.drawBitmap(blurredBitmap, this.mRectSrc, this.mRectDst, null);
            canvas.drawColor(this.needRemoveAlphaColor() ? BlurView.removeAlphaColor(this.mOverlayColor) : this.mOverlayColor);
        } else {
            Bitmap overlyBitmap = this.drawOverlyColor(Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888));
            if (overlyBitmap != null) {
                canvas.drawBitmap(overlyBitmap, 0.0f, 0.0f, null);
            }
        }
    }

    private Bitmap getRoundedCornerBitmap(Bitmap bitmap, Rect mRectDst) {
        if ((bitmap = this.drawOverlyColor(this.resizeImage(bitmap, mRectDst.width(), mRectDst.height()))) == null) {
            return null;
        }
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)bitmapShader);
        canvas.drawRoundRect(new RectF(mRectDst), this.mRadius, this.mRadius, paint);
        return output;
    }

    private Bitmap drawOverlyColor(Bitmap bitmap) {
        if (bitmap != null) {
            Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(output);
            Rect originRect = new Rect();
            originRect.set(0, 0, bitmap.getWidth(), bitmap.getHeight());
            canvas.drawBitmap(bitmap, originRect, originRect, this.overlayPaint);
            canvas.drawColor(this.needRemoveAlphaColor() ? BlurView.removeAlphaColor(this.mOverlayColor) : this.mOverlayColor);
            return output;
        }
        return null;
    }

    private Bitmap resizeImage(Bitmap bitmap, int newWidth, int newHeight) {
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            float scaleWidth = (float)newWidth / (float)width;
            float scaleHeight = (float)newHeight / (float)height;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        return null;
    }

    public boolean isUseBlur() {
        return this.useBlur;
    }

    public BlurView setUseBlur(boolean useBlur) {
        this.useBlur = useBlur;
        this.invalidate();
        return this;
    }

    private boolean needRemoveAlphaColor() {
        if (this.overrideOverlayColor) {
            return false;
        }
        return !supportRenderScript || !this.useBlur;
    }

    private static int removeAlphaColor(@ColorInt int color2) {
        int alpha = 255;
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    private static int replaceAlphaColor(@ColorInt int color2, int alpha) {
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    static boolean isDebug() {
        return DEBUGMODE && DialogX.DEBUGMODE;
    }

    private static void log(Object o) {
        if (BlurView.isDebug()) {
            Log.i((String)">>>", (String)("DialogX.BlurView: " + o.toString()));
        }
    }

    public static void error(Object o) {
        if (BlurView.isDebug()) {
            Log.e((String)">>>", (String)o.toString());
        }
    }

    public BlurView setOverrideOverlayColor(boolean overrideOverlayColor) {
        BlurView.log("setOverrideOverlayColor: " + overrideOverlayColor);
        this.overrideOverlayColor = overrideOverlayColor;
        return this;
    }

    static {
        supportRenderScript = false;
        new Thread(){

            @Override
            public void run() {
                try {
                    BlurView.class.getClassLoader().loadClass(RenderScript.class.getCanonicalName());
                    supportRenderScript = true;
                }
                catch (Throwable e) {
                    if (BlurView.isDebug()) {
                        e.printStackTrace();
                    }
                    supportRenderScript = false;
                }
            }
        }.start();
        DEBUGMODE = false;
    }
}

