/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.function.Consumer;
import kong.unirest.GenericType;
import kong.unirest.ObjectMapper;
import kong.unirest.UnirestException;

public class JacksonObjectMapper
implements ObjectMapper {
    private final com.fasterxml.jackson.databind.ObjectMapper om;

    public JacksonObjectMapper() {
        this((com.fasterxml.jackson.databind.ObjectMapper c) -> {});
    }

    public JacksonObjectMapper(Consumer<com.fasterxml.jackson.databind.ObjectMapper> configurations) {
        this(new com.fasterxml.jackson.databind.ObjectMapper());
        this.om.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true);
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.om.registerModule((Module)new JavaTimeModule());
        configurations.accept(this.om);
    }

    public JacksonObjectMapper(com.fasterxml.jackson.databind.ObjectMapper om) {
        this.om = om;
    }

    public com.fasterxml.jackson.databind.ObjectMapper getJacksonMapper() {
        return this.om;
    }

    public <T> T readValue(String value, Class<T> valueType) {
        try {
            return (T)this.om.readValue(value, valueType);
        }
        catch (IOException e) {
            throw new UnirestException((Exception)e);
        }
    }

    public <T> T readValue(String value, GenericType<T> genericType) {
        try {
            return (T)this.om.readValue(value, this.om.constructType(genericType.getType()));
        }
        catch (IOException e) {
            throw new UnirestException((Exception)e);
        }
    }

    public String writeValue(Object value) {
        try {
            return this.om.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UnirestException((Exception)((Object)e));
        }
    }
}

