/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Collection;
import kong.unirest.ObjectMapper;
import kong.unirest.UnirestException;
import kong.unirest.jackson.JacksonArray;
import kong.unirest.jackson.JacksonElement;
import kong.unirest.jackson.JacksonObject;
import kong.unirest.jackson.JacksonObjectMapper;
import kong.unirest.jackson.JacksonPrimitive;
import kong.unirest.json.JSONElement;
import kong.unirest.json.JSONException;
import kong.unirest.json.JsonEngine;

public class JacksonEngine
implements JsonEngine {
    private com.fasterxml.jackson.databind.ObjectMapper om;
    private ObjectMapper objm = new JacksonObjectMapper();

    public JacksonEngine() {
        this.om = JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES}).build();
    }

    public String toPrettyJson(JsonEngine.Element obj) {
        try {
            return this.om.writerWithDefaultPrettyPrinter().writeValueAsString(obj.getEngineElement());
        }
        catch (JsonProcessingException e) {
            throw new UnirestException((Exception)((Object)e));
        }
    }

    public String toJson(JsonEngine.Element obj) {
        try {
            return this.om.writeValueAsString(obj.getEngineElement());
        }
        catch (JsonProcessingException e) {
            throw new UnirestException((Exception)((Object)e));
        }
    }

    public void toJson(JsonEngine.Element obj, Writer sw) {
        try {
            this.om.writeValue(sw, obj.getEngineElement());
        }
        catch (IOException e) {
            throw new JSONException((Exception)e);
        }
    }

    public void toPrettyJson(JsonEngine.Element obj, Writer sw) {
        try {
            this.om.writerWithDefaultPrettyPrinter().writeValue(sw, obj.getEngineElement());
        }
        catch (IOException e) {
            throw new JSONException((Exception)e);
        }
    }

    public JsonEngine.Element toJsonTree(Object obj) {
        return JacksonElement.wrap((JsonNode)this.om.convertValue(obj, JsonNode.class));
    }

    public JsonEngine.Object newEngineObject() {
        return new JacksonObject(this.om.createObjectNode());
    }

    public JsonEngine.Object newEngineObject(String string) throws JSONException {
        try {
            return new JacksonObject((ObjectNode)this.om.readValue(string, ObjectNode.class));
        }
        catch (JsonProcessingException e) {
            throw new JSONException("Invalid JSON");
        }
    }

    public JsonEngine.Array newJsonArray(String jsonString) throws JSONException {
        try {
            return new JacksonArray((ArrayNode)this.om.readValue(jsonString, ArrayNode.class));
        }
        catch (JsonProcessingException e) {
            throw new JSONException("Invalid JSON");
        }
    }

    public JsonEngine.Array newJsonArray(Collection<?> collection) {
        JacksonArray a = new JacksonArray(this.om.createArrayNode());
        for (Object o : collection) {
            this.add(a, o);
        }
        return a;
    }

    private void add(JacksonArray a, Object o) {
        if (o instanceof Number) {
            a.add((Number)o);
        } else if (o instanceof String) {
            a.add((String)o);
        } else if (o instanceof Boolean) {
            a.add((Boolean)o);
        } else if (o instanceof JSONElement) {
            a.add(((JSONElement)o).getElement());
        } else if (o instanceof JsonEngine.Element) {
            a.add((JsonEngine.Element)o);
        } else {
            JsonNode tree = (JsonNode)this.om.convertValue(o, JsonNode.class);
            a.add(JacksonElement.wrap(tree));
        }
    }

    public JsonEngine.Array newEngineArray() {
        return new JacksonArray(this.om.createArrayNode());
    }

    public <T> T fromJson(JsonEngine.Element obj, Class<T> mapClass) {
        return (T)this.om.convertValue(obj.getEngineElement(), mapClass);
    }

    public <T extends Enum> JsonEngine.Primitive newJsonPrimitive(T enumValue) {
        if (enumValue == null) {
            return new JacksonPrimitive((ValueNode)NullNode.getInstance());
        }
        return this.newJsonPrimitive(enumValue.name());
    }

    public JsonEngine.Primitive newJsonPrimitive(String string) {
        return this.convert(string, v -> new TextNode(v));
    }

    public JsonEngine.Primitive newJsonPrimitive(Number number) {
        if (number instanceof Integer) {
            return this.convert((Integer)number, IntNode::new);
        }
        if (number instanceof Long) {
            return this.convert((Long)number, LongNode::new);
        }
        if (number instanceof Double) {
            return this.convert((Double)number, DoubleNode::new);
        }
        if (number instanceof BigInteger) {
            return this.convert((BigInteger)number, BigIntegerNode::new);
        }
        if (number instanceof Float) {
            return this.convert((Float)number, FloatNode::new);
        }
        return new JacksonPrimitive((ValueNode)NullNode.getInstance());
    }

    public JsonEngine.Primitive newJsonPrimitive(Boolean bool) {
        return this.convert(bool, v -> BooleanNode.valueOf((boolean)v));
    }

    public ObjectMapper getObjectMapper() {
        return this.objm;
    }

    public String quote(Object s) {
        try {
            return this.om.writeValueAsString(s);
        }
        catch (JsonProcessingException e) {
            throw new JSONException((Exception)((Object)e));
        }
    }

    private <T> JsonEngine.Primitive convert(T value, ValueSupplier<T> supplier) {
        try {
            if (value == null) {
                return new JacksonPrimitive((ValueNode)NullNode.getInstance());
            }
            return new JacksonPrimitive(supplier.getIt(value));
        }
        catch (JsonProcessingException e) {
            throw new UnirestException((Exception)((Object)e));
        }
    }

    @FunctionalInterface
    private static interface ValueSupplier<V> {
        public ValueNode getIt(V var1) throws JsonProcessingException;
    }
}

