/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.util.Optional;
import java.util.function.Consumer;
import kong.unirest.core.BaseResponse;
import kong.unirest.core.Headers;
import kong.unirest.core.MockConfig;
import kong.unirest.core.MockRawResponse;
import kong.unirest.core.RawResponse;
import kong.unirest.core.UnirestParsingException;

public class MockResponse<T>
extends BaseResponse<T> {
    private final MockConfig mockConfig;
    private Optional<UnirestParsingException> ex = Optional.empty();
    private final T body;

    public MockResponse(int status, String statusText, T body) {
        this(status, statusText, body, new MockConfig());
    }

    public MockResponse(int status, String statusText, T body, MockConfig config) {
        super((RawResponse)new MockRawResponse("", new Headers(), status, statusText, config, null));
        this.mockConfig = config;
        this.body = body;
    }

    public static <T> MockResponse<T> ok(T body) {
        return new MockResponse<T>(200, "ok", body);
    }

    public static <T> MockResponse<T> bad(T body) {
        return new MockResponse<T>(400, "bad request", body);
    }

    public static <T> MockResponse<T> of(int status, T body) {
        return new MockResponse<T>(status, String.valueOf(status), body);
    }

    public static <T> MockResponse<T> of(int status, String statusText, T body) {
        return new MockResponse<T>(status, statusText, body);
    }

    public MockConfig config() {
        return this.mockConfig;
    }

    public T getBody() {
        return this.body;
    }

    protected String getRawBody() {
        return String.valueOf(this.body);
    }

    public Optional<UnirestParsingException> getParsingError() {
        return this.ex;
    }

    public MockResponse<T> withHeader(String key, String value) {
        this.getHeaders().add(key, value);
        return this;
    }

    public MockResponse<T> failedToParse() {
        return this.failedToParse(new Exception("oops"), String.valueOf(this.body));
    }

    public MockResponse<T> failedToParse(Exception e, String originalBody) {
        this.ex = Optional.of(new UnirestParsingException(originalBody, e));
        return this;
    }

    public MockResponse<T> withConfigOptions(Consumer<MockConfig> c) {
        c.accept(this.mockConfig);
        return this;
    }
}

