/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.net.http.WebSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kong.unirest.core.Assert;
import kong.unirest.core.Client;
import kong.unirest.core.Config;
import kong.unirest.core.Expectation;
import kong.unirest.core.ExpectedResponse;
import kong.unirest.core.HttpMethod;
import kong.unirest.core.HttpRequest;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.HttpResponseSummary;
import kong.unirest.core.Invocation;
import kong.unirest.core.MetricContext;
import kong.unirest.core.MockListener;
import kong.unirest.core.MockWebSocket;
import kong.unirest.core.Path;
import kong.unirest.core.RawResponse;
import kong.unirest.core.ResponseSummary;
import kong.unirest.core.Routes;
import kong.unirest.core.SocketSet;
import kong.unirest.core.SseHandler;
import kong.unirest.core.SseRequest;
import kong.unirest.core.Unirest;
import kong.unirest.core.UnirestAssertion;
import kong.unirest.core.UnirestException;
import kong.unirest.core.UnirestInstance;
import kong.unirest.core.WebSocketRequest;
import kong.unirest.core.WebSocketResponse;
import kong.unirest.core.java.Event;

public class MockClient
implements Client {
    private final Supplier<Config> config;
    private List<Routes> routes = new ArrayList<Routes>();
    private SocketSet remoteSocket;
    private Invocation defaultResponse;

    public MockClient(Supplier<Config> config) {
        this.config = config;
    }

    public static MockClient register() {
        return MockClient.register(Unirest.primaryInstance());
    }

    public static MockClient register(UnirestInstance unirest) {
        MockClient client = new MockClient(() -> ((UnirestInstance)unirest).config());
        unirest.config().httpClient((Client)client);
        return client;
    }

    public static void clear() {
        MockClient.clear(Unirest.primaryInstance());
    }

    public static void clear(UnirestInstance unirest) {
        if (unirest.config().getClient() instanceof MockClient) {
            unirest.config().httpClient((Client)null);
        }
    }

    public <T> HttpResponse<T> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer, Class<?> resultType) {
        Routes exp = this.findExpectation(request);
        Config c = this.config.get();
        c.getUniInterceptor().onRequest(request, c);
        MetricContext metric = c.getMetric().begin(request.toSummary());
        RawResponse response = exp.exchange(request, c);
        metric.complete((HttpResponseSummary)new ResponseSummary(response), null);
        HttpResponse<T> rez = transformer.apply(response);
        c.getUniInterceptor().onResponse(rez, request.toSummary(), c);
        return rez;
    }

    private Routes findExpectation(HttpRequest request) {
        return this.routes.stream().filter(e -> e.matches(request)).findFirst().orElseGet(() -> this.createNewPath(request));
    }

    private Routes createNewPath(HttpRequest request) {
        Routes p = new Routes(request, this.defaultResponse);
        this.routes.add(p);
        return p;
    }

    public <T> CompletableFuture<HttpResponse<T>> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer, CompletableFuture<HttpResponse<T>> callback, Class<?> resultTypes) {
        return CompletableFuture.supplyAsync(() -> this.request(request, transformer, resultTypes));
    }

    public WebSocketResponse websocket(WebSocketRequest request, WebSocket.Listener listener) {
        MockWebSocket clientSocket = new MockWebSocket();
        WebSocket.Listener clientListener = listener;
        MockWebSocket serverWebSocket = new MockWebSocket();
        MockListener serverListener = new MockListener();
        this.remoteSocket = new SocketSet<MockWebSocket, MockListener>(serverWebSocket, serverListener, "server");
        clientSocket.init(this.remoteSocket);
        serverWebSocket.init(new SocketSet<MockWebSocket, WebSocket.Listener>(clientSocket, clientListener, "client"));
        return new WebSocketResponse(CompletableFuture.completedFuture(clientSocket), clientListener);
    }

    public CompletableFuture<Void> sse(SseRequest request, SseHandler handler) {
        return null;
    }

    public Stream<Event> sse(SseRequest request) {
        return Stream.empty();
    }

    public SocketSet<MockWebSocket, MockListener> serversSocket() {
        if (this.remoteSocket == null) {
            throw new UnirestException("No Socket Yet Established");
        }
        return this.remoteSocket;
    }

    public Object getClient() {
        return this;
    }

    public Expectation expect(HttpMethod method, String path) {
        Path p = new Path(path);
        Routes exp = this.findByPath(method, p).orElseGet(() -> new Routes(method, p));
        if (!this.routes.contains(exp)) {
            this.routes.add(exp);
        }
        return exp.newExpectation();
    }

    public Expectation expect(HttpMethod method) {
        return this.expect(method, null);
    }

    public Assert assertThat(HttpMethod method, String path) {
        return this.findByPath(method, new Path(path)).orElseThrow(() -> new UnirestAssertion(String.format("No Matching Invocation:: %s %s", method, path), new Object[0]));
    }

    private Optional<Routes> findByPath(HttpMethod get, Path path) {
        return this.routes.stream().filter(e -> e.matches(get, path)).findFirst();
    }

    public void verifyAll() {
        this.routes.forEach(Routes::verifyAll);
    }

    public void reset() {
        this.routes.clear();
        this.defaultResponse = null;
    }

    public ExpectedResponse defaultResponse() {
        this.defaultResponse = new Invocation();
        return this.defaultResponse.thenReturn();
    }
}

