/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import kong.unirest.core.UnirestAssertion;

public class MockListener
implements WebSocket.Listener {
    private List<Message> messagesReceived = new ArrayList<Message>();
    private ByteBuffer ping;
    private ByteBuffer pong;
    private boolean open = false;
    private int closedStatus;
    private String closedMessage;

    @Override
    public void onOpen(WebSocket webSocket) {
        this.open = true;
        WebSocket.Listener.super.onOpen(webSocket);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        this.messagesReceived.add(new Message(String.valueOf(data), last));
        return WebSocket.Listener.super.onText(webSocket, data, last);
    }

    @Override
    public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        this.messagesReceived.add(new Message(data, last));
        return WebSocket.Listener.super.onBinary(webSocket, data, last);
    }

    @Override
    public CompletionStage<?> onPing(WebSocket webSocket, ByteBuffer message) {
        this.ping = message;
        webSocket.sendPong(message);
        return WebSocket.Listener.super.onPing(webSocket, message);
    }

    @Override
    public CompletionStage<?> onPong(WebSocket webSocket, ByteBuffer message) {
        this.pong = message;
        return WebSocket.Listener.super.onPong(webSocket, message);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        this.open = false;
        this.closedStatus = statusCode;
        this.closedMessage = reason;
        return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        WebSocket.Listener.super.onError(webSocket, error);
    }

    public void assertReceivedMessage(Object message, boolean last) {
        if (!this.messagesReceived.stream().anyMatch(e -> Objects.equals(e.data, message) && Objects.equals(e.last, last))) {
            throw new UnirestAssertion("Did not receive any message: [%s : %s] ", message, last);
        }
    }

    public void assertIsClosed(int status, String message) {
        if (this.open) {
            throw new UnirestAssertion("Expected to be closed but was not", new Object[0]);
        }
        if (this.closedStatus != status || !Objects.equals(this.closedMessage, message)) {
            throw new UnirestAssertion("Incorrect Closed Status/Message. Expected [%s : %s] but got [%s : %s]", status, message, this.closedStatus, this.closedMessage);
        }
    }

    public void assertPing(ByteBuffer message) {
        if (!Objects.equals(this.ping, message)) {
            throw new UnirestAssertion("Expected Ping Call with buffer %s but got %s", message, this.ping);
        }
    }

    public void assertPong(ByteBuffer message) {
        if (!message.equals(this.pong)) {
            throw new UnirestAssertion("Expected Pong Message %s but got %s", message, this.pong);
        }
    }

    public void assertIsOpen() {
        if (!this.open) {
            throw new UnirestAssertion("Expected socket to be open but was closed.", new Object[0]);
        }
    }

    private class Message {
        private final Object data;
        private final boolean last;

        public Message(Object data, boolean last) {
            this.data = data;
            this.last = last;
        }
    }
}

