/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core;

import java.util.Objects;

public abstract class Times {
    public static Times exactlyOnce() {
        return Times.exactly(1);
    }

    public static Times exactly(int times) {
        return new Exactly(times);
    }

    public static Times atLeastOnce() {
        return Times.atLeast(1);
    }

    public static Times atLeast(int times) {
        return new AtLeast(times);
    }

    public static Times never() {
        return Times.exactly(0);
    }

    public static Times atMost(int times) {
        return new AtMost(times);
    }

    public abstract EvaluationResult matches(int var1);

    public static class EvaluationResult {
        private static final EvaluationResult SUCCESS = new EvaluationResult(true, null);
        private final boolean success;
        private final String message;

        public static EvaluationResult success() {
            return SUCCESS;
        }

        public static EvaluationResult fail(String message, Object ... values) {
            return new EvaluationResult(false, String.format(message, values));
        }

        public EvaluationResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }
    }

    private static class AtMost
    extends Times {
        private final int times;

        public AtMost(int times) {
            this.times = times;
        }

        @Override
        public EvaluationResult matches(int number) {
            if (number <= this.times) {
                return EvaluationResult.success();
            }
            return EvaluationResult.fail("Expected no more than %s invocations but got %s", this.times, number);
        }
    }

    private static class AtLeast
    extends Times {
        private final int times;

        AtLeast(int times) {
            this.times = times;
        }

        @Override
        public EvaluationResult matches(int number) {
            if (number >= this.times) {
                return EvaluationResult.success();
            }
            return EvaluationResult.fail("Expected at least %s invocations but got %s", this.times, number);
        }
    }

    private static class Exactly
    extends Times {
        private final int times;

        Exactly(int times) {
            this.times = times;
        }

        @Override
        public EvaluationResult matches(int number) {
            if (Objects.equals(number, this.times)) {
                return EvaluationResult.success();
            }
            return EvaluationResult.fail("Expected exactly %s invocations but got %s", this.times, number);
        }
    }
}

