/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.modules.jackson;

import java.util.function.Consumer;
import kong.unirest.core.GenericType;
import kong.unirest.core.ObjectMapper;
import kong.unirest.core.UnirestException;
import tools.jackson.core.JacksonException;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.json.JsonMapper;

public class JacksonObjectMapper
implements ObjectMapper {
    private tools.jackson.databind.ObjectMapper om;

    public JacksonObjectMapper() {
        this((JsonMapper.Builder c) -> {});
    }

    public JacksonObjectMapper(Consumer<JsonMapper.Builder> configurations) {
        JsonMapper.Builder builder = JsonMapper.builderWithJackson2Defaults();
        builder.configure(StreamWriteFeature.IGNORE_UNKNOWN, true);
        builder.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        configurations.accept(builder);
        this.om = builder.build();
    }

    public JacksonObjectMapper(tools.jackson.databind.ObjectMapper om) {
        this.om = om;
    }

    public tools.jackson.databind.ObjectMapper getJacksonMapper() {
        return this.om;
    }

    public <T> T readValue(String value, Class<T> valueType) {
        try {
            return (T)this.om.readValue(value, valueType);
        }
        catch (JacksonException e) {
            throw new UnirestException((Exception)((Object)e));
        }
    }

    public <T> T readValue(String value, GenericType<T> genericType) {
        try {
            return (T)this.om.readValue(value, this.om.constructType(genericType.getType()));
        }
        catch (JacksonException e) {
            throw new UnirestException((Exception)((Object)e));
        }
    }

    public String writeValue(Object value) {
        try {
            return this.om.writeValueAsString(value);
        }
        catch (JacksonException e) {
            throw new UnirestException((Exception)((Object)e));
        }
    }
}

