/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.modules.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Collection;
import kong.unirest.core.UnirestException;
import kong.unirest.core.json.JSONElement;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JsonEngine;
import kong.unirest.modules.jackson.JacksonArray;
import kong.unirest.modules.jackson.JacksonElement;
import kong.unirest.modules.jackson.JacksonObject;
import kong.unirest.modules.jackson.JacksonObjectMapper;
import kong.unirest.modules.jackson.JacksonPrimitive;
import tools.jackson.core.JacksonException;
import tools.jackson.core.json.JsonReadFeature;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BigIntegerNode;
import tools.jackson.databind.node.BooleanNode;
import tools.jackson.databind.node.DoubleNode;
import tools.jackson.databind.node.FloatNode;
import tools.jackson.databind.node.IntNode;
import tools.jackson.databind.node.LongNode;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.StringNode;
import tools.jackson.databind.node.ValueNode;

public class JacksonEngine
implements JsonEngine {
    private ObjectMapper om;
    private kong.unirest.core.ObjectMapper objm = new JacksonObjectMapper();

    public JacksonEngine() {
        this.om = ((JsonMapper.Builder)JsonMapper.builderWithJackson2Defaults().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNQUOTED_PROPERTY_NAMES}).changeDefaultVisibility(vc -> vc.withFieldVisibility(JsonAutoDetect.Visibility.ANY))).build();
    }

    public String toPrettyJson(JsonEngine.Element obj) {
        try {
            return this.om.writerWithDefaultPrettyPrinter().writeValueAsString(obj.getEngineElement());
        }
        catch (JacksonException e) {
            throw new UnirestException((Exception)((Object)e));
        }
    }

    public String toJson(JsonEngine.Element obj) {
        try {
            return this.om.writeValueAsString(obj.getEngineElement());
        }
        catch (JacksonException e) {
            throw new UnirestException((Exception)((Object)e));
        }
    }

    public void toJson(JsonEngine.Element obj, Writer sw) {
        try {
            this.om.writeValue(sw, obj.getEngineElement());
        }
        catch (JacksonException e) {
            throw new JSONException((Exception)((Object)e));
        }
    }

    public void toPrettyJson(JsonEngine.Element obj, Writer sw) {
        try {
            this.om.writerWithDefaultPrettyPrinter().writeValue(sw, obj.getEngineElement());
        }
        catch (JacksonException e) {
            throw new JSONException((Exception)((Object)e));
        }
    }

    public JsonEngine.Element toJsonTree(Object obj) {
        return JacksonElement.wrap(this.om.valueToTree(obj));
    }

    public JsonEngine.Object newEngineObject() {
        return new JacksonObject(this.om.createObjectNode());
    }

    public JsonEngine.Object newEngineObject(String string) throws JSONException {
        try {
            return new JacksonObject((ObjectNode)this.om.readValue(string, ObjectNode.class));
        }
        catch (JacksonException e) {
            throw new JSONException("Invalid JSON");
        }
    }

    public JsonEngine.Array newJsonArray(String jsonString) throws JSONException {
        try {
            return new JacksonArray((ArrayNode)this.om.readValue(jsonString, ArrayNode.class));
        }
        catch (JacksonException e) {
            throw new JSONException("Invalid JSON");
        }
    }

    public JsonEngine.Array newJsonArray(Collection<?> collection) {
        JacksonArray a = new JacksonArray(this.om.createArrayNode());
        for (Object o : collection) {
            this.add(a, o);
        }
        return a;
    }

    private void add(JacksonArray a, Object o) {
        if (o instanceof Number) {
            a.add((Number)o);
        } else if (o instanceof String) {
            a.add((String)o);
        } else if (o instanceof Boolean) {
            a.add((Boolean)o);
        } else if (o instanceof JSONElement) {
            a.add(((JSONElement)o).getElement());
        } else if (o instanceof JsonEngine.Element) {
            a.add((JsonEngine.Element)o);
        } else {
            JsonNode tree = (JsonNode)this.om.convertValue(o, JsonNode.class);
            a.add(JacksonElement.wrap(tree));
        }
    }

    public JsonEngine.Array newEngineArray() {
        return new JacksonArray(this.om.createArrayNode());
    }

    public <T> T fromJson(JsonEngine.Element obj, Class<T> mapClass) {
        return (T)this.om.convertValue(obj.getEngineElement(), mapClass);
    }

    public <T extends Enum> JsonEngine.Primitive newJsonPrimitive(T enumValue) {
        if (enumValue == null) {
            return new JacksonPrimitive((ValueNode)NullNode.getInstance());
        }
        return this.newJsonPrimitive(enumValue.name());
    }

    public JsonEngine.Primitive newJsonPrimitive(String string) {
        return this.convert(string, StringNode::new);
    }

    public JsonEngine.Primitive newJsonPrimitive(Number number) {
        if (number instanceof Integer) {
            return this.convert((Integer)number, IntNode::new);
        }
        if (number instanceof Long) {
            return this.convert((Long)number, LongNode::new);
        }
        if (number instanceof Double) {
            return this.convert((Double)number, DoubleNode::new);
        }
        if (number instanceof BigInteger) {
            return this.convert((BigInteger)number, BigIntegerNode::new);
        }
        if (number instanceof Float) {
            return this.convert((Float)number, FloatNode::new);
        }
        return new JacksonPrimitive((ValueNode)NullNode.getInstance());
    }

    public JsonEngine.Primitive newJsonPrimitive(Boolean bool) {
        return this.convert(bool, BooleanNode::valueOf);
    }

    public kong.unirest.core.ObjectMapper getObjectMapper() {
        return this.objm;
    }

    public String quote(Object s) {
        try {
            return this.om.writeValueAsString(s);
        }
        catch (JacksonException e) {
            throw new JSONException((Exception)((Object)e));
        }
    }

    private <T> JsonEngine.Primitive convert(T value, ValueSupplier<T> supplier) {
        try {
            if (value == null) {
                return new JacksonPrimitive((ValueNode)NullNode.getInstance());
            }
            return new JacksonPrimitive(supplier.getIt(value));
        }
        catch (JacksonException e) {
            throw new UnirestException((Exception)((Object)e));
        }
    }

    @FunctionalInterface
    private static interface ValueSupplier<V> {
        public ValueNode getIt(V var1);
    }
}

