/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.modules.jackson;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kong.unirest.core.json.JsonEngine;
import kong.unirest.modules.jackson.JacksonElement;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.NullNode;

class JacksonArray
extends JacksonElement<ArrayNode>
implements JsonEngine.Array {
    JacksonArray(ArrayNode element) {
        super(element);
    }

    public int size() {
        return ((ArrayNode)this.element).size();
    }

    public JsonEngine.Element get(int index) {
        this.validateIndex(index);
        return JacksonArray.wrap(((ArrayNode)this.element).get(index));
    }

    private void validateIndex(int index) {
        if (((ArrayNode)this.element).size() < index + 1) {
            throw new IndexOutOfBoundsException();
        }
    }

    public JsonEngine.Element remove(int index) {
        return JacksonArray.wrap(((ArrayNode)this.element).remove(index));
    }

    public JsonEngine.Element put(int index, Number number) {
        if (number instanceof Integer) {
            ((ArrayNode)this.element).insert(index, (Integer)number);
        } else if (number instanceof Double) {
            ((ArrayNode)this.element).insert(index, (Double)number);
        } else if (number instanceof BigInteger) {
            ((ArrayNode)this.element).insert(index, (BigInteger)number);
        } else if (number instanceof Float) {
            ((ArrayNode)this.element).insert(index, (Float)number);
        } else if (number instanceof BigDecimal) {
            ((ArrayNode)this.element).insert(index, (BigDecimal)number);
        }
        return this;
    }

    public JsonEngine.Element put(int index, String value) {
        ((ArrayNode)this.element).insert(index, value);
        return this;
    }

    public JsonEngine.Element put(int index, Boolean value) {
        ((ArrayNode)this.element).insert(index, value);
        return this;
    }

    public void add(JsonEngine.Element obj) {
        if (obj == null) {
            ((ArrayNode)this.element).add((JsonNode)NullNode.getInstance());
            return;
        }
        ((ArrayNode)this.element).add((JsonNode)obj.getEngineElement());
    }

    public void set(int index, JsonEngine.Element o) {
        if (o == null) {
            ((ArrayNode)this.element).set(index, (JsonNode)NullNode.getInstance());
        } else {
            ((ArrayNode)this.element).set(index, (JsonNode)o.getEngineElement());
        }
    }

    public void add(Number number) {
        if (number instanceof Integer) {
            ((ArrayNode)this.element).add((Integer)number);
        } else if (number instanceof Double) {
            ((ArrayNode)this.element).add((Double)number);
        } else if (number instanceof Long) {
            ((ArrayNode)this.element).add((Long)number);
        } else if (number instanceof BigInteger) {
            ((ArrayNode)this.element).add((BigInteger)number);
        } else if (number instanceof Float) {
            ((ArrayNode)this.element).add((Float)number);
        } else if (number instanceof BigDecimal) {
            ((ArrayNode)this.element).add((BigDecimal)number);
        }
    }

    public void add(String str) {
        ((ArrayNode)this.element).add(str);
    }

    public void add(Boolean bool) {
        ((ArrayNode)this.element).add(bool);
    }

    public String join(String token) {
        return StreamSupport.stream(((ArrayNode)this.element).spliterator(), false).map(String::valueOf).collect(Collectors.joining(token));
    }
}

