/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.java;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Flow;

class Upstream {
    public static final Flow.Subscription NOOP_SUBSCRIPTION = new Flow.Subscription(){

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
        }
    };
    private static final VarHandle SUBSCRIPTION;
    private volatile Flow.Subscription subscription;

    public boolean setOrCancel(Flow.Subscription incoming) {
        if (!SUBSCRIPTION.compareAndSet(this, null, incoming)) {
            incoming.cancel();
            return false;
        }
        return true;
    }

    public void request(long n) {
        Flow.Subscription currentSubscription = this.subscription;
        if (currentSubscription != null) {
            currentSubscription.request(n);
        }
    }

    public void cancel() {
        Flow.Subscription currentSubscription = SUBSCRIPTION.getAndSet(this, NOOP_SUBSCRIPTION);
        if (currentSubscription != null) {
            currentSubscription.cancel();
        }
    }

    public void clear() {
        this.subscription = NOOP_SUBSCRIPTION;
    }

    static {
        try {
            SUBSCRIPTION = MethodHandles.lookup().findVarHandle(Upstream.class, "subscription", Flow.Subscription.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

