/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.java;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import kong.unirest.ProgressMonitor;
import kong.unirest.java.BoundaryAppender;
import kong.unirest.java.MultipartBodyPublisher;
import kong.unirest.java.Part;
import kong.unirest.java.PartSubscriber;

class MultipartSubscription
implements Flow.Subscription {
    static final Executor SYNC_EXECUTOR = Runnable::run;
    private static final int RUN = 1;
    private static final int KEEP_ALIVE = 2;
    private static final int CANCELLED = 4;
    private static final int SUBSCRIBED = 8;
    private static final VarHandle STATE;
    private static final VarHandle PENDING_ERROR;
    private static final VarHandle DEMAND;
    private static final VarHandle PART_SUBSCRIBER;
    private static final Flow.Subscriber<ByteBuffer> CANCELLED_SUBSCRIBER;
    private final String boundary;
    private final List<Part> parts;
    private int partIndex;
    private boolean complete;
    private final ProgressMonitor monitor;
    private final Flow.Subscriber<? super ByteBuffer> downstream;
    private final Executor executor;
    private volatile Flow.Subscriber<ByteBuffer> partSubscriber;
    private volatile int state;
    private volatile long demand;
    private volatile Throwable pendingError;

    MultipartSubscription(String boundary, List<Part> parts, ProgressMonitor monitor, Flow.Subscriber<? super ByteBuffer> downstream) {
        this.monitor = monitor;
        this.downstream = downstream;
        this.executor = SYNC_EXECUTOR;
        this.boundary = boundary;
        this.parts = parts;
    }

    @Override
    public final void request(long n) {
        if (n > 0L && this.getAndAddDemand(this, DEMAND, n) == 0L) {
            this.signal();
        } else if (n <= 0L) {
            this.signalError(new IllegalArgumentException("non-positive subscription request"));
        }
    }

    @Override
    public final void cancel() {
        if ((this.getAndBitwiseOrState(4) & 4) == 0) {
            this.abort(true);
        }
    }

    private long getAndAddDemand(Object owner, VarHandle demand, long n) {
        long addedDemand;
        long currentDemand;
        do {
            if ((addedDemand = (currentDemand = demand.getVolatile(owner)) + n) >= 0L) continue;
            addedDemand = Long.MAX_VALUE;
        } while (!demand.compareAndSet(owner, currentDemand, addedDemand));
        return currentDemand;
    }

    private long subtractAndGetDemand(Object owner, VarHandle demand, long n) {
        return demand.getAndAdd(owner, -n) - n;
    }

    public final void signal(boolean force) {
        if (force || this.demand > 0L) {
            this.signal();
        }
    }

    public final void signalError(Throwable error) {
        this.propagateError(error);
        this.signal();
    }

    private final boolean isCancelled() {
        return (this.state & 4) != 0;
    }

    private final boolean hasPendingErrors() {
        return this.pendingError != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cancelOnError(Flow.Subscriber<? super ByteBuffer> downstream, Throwable error, boolean flowInterrupted) {
        if ((this.getAndBitwiseOrState(4) & 4) == 0) {
            try {
                downstream.onError(error);
            }
            finally {
                this.abort(flowInterrupted);
            }
        }
    }

    private final void cancelOnComplete(Flow.Subscriber<? super ByteBuffer> downstream) {
        if ((this.getAndBitwiseOrState(4) & 4) == 0) {
            try {
                downstream.onComplete();
            }
            finally {
                this.abort(false);
            }
        }
    }

    private final boolean submitOnNext(Flow.Subscriber<? super ByteBuffer> downstream, ByteBuffer item) {
        if (!this.isCancelled() && !this.hasPendingErrors()) {
            try {
                downstream.onNext(item);
                return true;
            }
            catch (Throwable t) {
                Throwable error = this.propagateError(t);
                this.pendingError = null;
                this.cancelOnError(downstream, error, true);
            }
        }
        return false;
    }

    private void signal() {
        int s;
        boolean casSucceeded = false;
        while (!casSucceeded && ((s = this.state) & 4) == 0) {
            int setBit = (s & 1) != 0 ? 2 : 1;
            casSucceeded = STATE.compareAndSet(this, s, s | setBit);
            if (!casSucceeded || setBit != 1) continue;
            try {
                this.executor.execute(this::run);
            }
            catch (Error | RuntimeException e) {
                this.cancel();
                throw e;
            }
        }
    }

    private void run() {
        int s;
        Flow.Subscriber<? super ByteBuffer> d = this.downstream;
        this.subscribeOnDrain(d);
        long x = 0L;
        long r = this.demand;
        while (((s = this.state) & 4) == 0) {
            int unsetBit;
            boolean exhausted;
            Throwable error = this.pendingError;
            if (error != null) {
                this.pendingError = null;
                this.cancelOnError(d, error, false);
                continue;
            }
            long emitted = this.emit(d, r - x);
            if (emitted > 0L) {
                r = this.demand;
                if ((x += emitted) != r) continue;
                r = this.subtractAndGetDemand(this, DEMAND, x);
                x = 0L;
                continue;
            }
            if (r != (r = this.demand)) continue;
            boolean bl = exhausted = x <= 0L;
            if (!exhausted) {
                r = this.subtractAndGetDemand(this, DEMAND, x);
                x = 0L;
                exhausted = r <= 0L;
            }
            int n = unsetBit = (s & 2) != 0 ? 2 : 1;
            if (!exhausted || !STATE.compareAndSet(this, s, s & ~unsetBit) || unsetBit != 1) continue;
            break;
        }
    }

    private void subscribeOnDrain(Flow.Subscriber<? super ByteBuffer> downstream) {
        if ((this.state & 0xC) == 0 && (this.getAndBitwiseOrState(8) & 0xC) == 0) {
            try {
                downstream.onSubscribe(this);
            }
            catch (Throwable t) {
                Throwable e = this.propagateError(t);
                this.pendingError = null;
                this.cancelOnError(downstream, e, true);
            }
        }
    }

    private Throwable propagateError(Throwable error) {
        do {
            Throwable currentError;
            if ((currentError = this.pendingError) == null) continue;
            currentError.addSuppressed(error);
            return currentError;
        } while (!PENDING_ERROR.compareAndSet(this, null, error));
        return error;
    }

    private int getAndBitwiseOrState(int bits) {
        return STATE.getAndBitwiseOr(this, bits);
    }

    private long emit(Flow.Subscriber<? super ByteBuffer> downstream, long emit) {
        long submitted = 0L;
        while (true) {
            ByteBuffer batch;
            if (this.complete) {
                this.cancelOnComplete(downstream);
                return 0L;
            }
            if (submitted >= emit || (batch = this.pollNext()) == null) {
                return submitted;
            }
            if (!this.submitOnNext(downstream, batch)) break;
            ++submitted;
        }
        return 0L;
    }

    private void abort(boolean flowInterrupted) {
        Flow.Subscriber previous = PART_SUBSCRIBER.getAndSet(this, CANCELLED_SUBSCRIBER);
        if (previous instanceof PartSubscriber) {
            ((PartSubscriber)previous).abortUpstream(flowInterrupted);
        }
    }

    private ByteBuffer pollNext() {
        ByteBuffer next;
        Flow.Subscriber<ByteBuffer> subscriber = this.partSubscriber;
        if (subscriber instanceof PartSubscriber && (next = ((PartSubscriber)subscriber).pollNext()) != PartSubscriber.END_OF_PART) {
            return next;
        }
        return subscriber != CANCELLED_SUBSCRIBER ? this.nextPartHeaders() : null;
    }

    private ByteBuffer nextPartHeaders() {
        StringBuilder heading = new StringBuilder();
        BoundaryAppender.get(this.partIndex, this.parts.size()).append(heading, this.boundary);
        if (this.partIndex < this.parts.size()) {
            Part part;
            if (!this.subscribeToPart(part = this.parts.get(this.partIndex++))) {
                return null;
            }
            MultipartBodyPublisher.appendPartHeaders(heading, part);
            heading.append("\r\n");
        } else {
            this.partSubscriber = CANCELLED_SUBSCRIBER;
            this.complete = true;
        }
        return StandardCharsets.UTF_8.encode(CharBuffer.wrap(heading));
    }

    private boolean subscribeToPart(Part part) {
        PartSubscriber subscriber = new PartSubscriber(this, part, this.monitor);
        Flow.Subscriber<ByteBuffer> current = this.partSubscriber;
        if (current != CANCELLED_SUBSCRIBER && PART_SUBSCRIBER.compareAndSet(this, current, subscriber)) {
            part.bodyPublisher().subscribe(subscriber);
            return true;
        }
        return false;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            PART_SUBSCRIBER = lookup.findVarHandle(MultipartSubscription.class, "partSubscriber", Flow.Subscriber.class);
            STATE = lookup.findVarHandle(MultipartSubscription.class, "state", Integer.TYPE);
            DEMAND = lookup.findVarHandle(MultipartSubscription.class, "demand", Long.TYPE);
            PENDING_ERROR = lookup.findVarHandle(MultipartSubscription.class, "pendingError", Throwable.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
        CANCELLED_SUBSCRIBER = new Flow.Subscriber<ByteBuffer>(){

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
            }

            @Override
            public void onNext(ByteBuffer item) {
            }

            @Override
            public void onError(Throwable throwable) {
            }

            @Override
            public void onComplete() {
            }
        };
    }
}

