/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import kong.unirest.AsyncClient;
import kong.unirest.Config;
import kong.unirest.HttpRequest;
import kong.unirest.HttpResponse;
import kong.unirest.RawResponse;
import kong.unirest.UnirestConfigException;
import kong.unirest.UnirestException;
import kong.unirest.apache.ApacheNoRedirectStrategy;
import kong.unirest.apache.ApacheResponse;
import kong.unirest.apache.AsyncIdleConnectionMonitorThread;
import kong.unirest.apache.BaseApacheClient;
import kong.unirest.apache.RequestPrep;
import kong.unirest.apache.Util;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;

public class ApacheAsyncClient
extends BaseApacheClient
implements AsyncClient {
    private final HttpAsyncClient client;
    private final AsyncIdleConnectionMonitorThread syncMonitor;
    private final PoolingNHttpClientConnectionManager manager;
    private Config config;

    public ApacheAsyncClient(Config config) {
        this.config = config;
        try {
            this.manager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)new DefaultConnectingIOReactor());
            this.manager.setMaxTotal(config.getMaxConnections());
            this.manager.setDefaultMaxPerRoute(config.getMaxPerRoutes());
            HttpAsyncClientBuilder ab = HttpAsyncClientBuilder.create().setDefaultRequestConfig(this.getRequestConfig(config)).setConnectionManager((NHttpClientConnectionManager)this.manager).setDefaultCredentialsProvider(this.toApacheCreds(config.getProxy())).useSystemProperties();
            if (config.useSystemProperties()) {
                ab.useSystemProperties();
            }
            if (!config.getFollowRedirects()) {
                ab.setRedirectStrategy((RedirectStrategy)new ApacheNoRedirectStrategy());
            }
            if (!config.getEnabledCookieManagement()) {
                ab.disableCookieManagement();
            }
            config.getInterceptors().forEach(arg_0 -> ((HttpAsyncClientBuilder)ab).addInterceptorFirst(arg_0));
            CloseableHttpAsyncClient build = ab.build();
            build.start();
            this.syncMonitor = new AsyncIdleConnectionMonitorThread(this.manager);
            this.syncMonitor.tryStart();
            this.client = build;
        }
        catch (IOReactorException e) {
            throw new UnirestConfigException((Exception)((Object)e));
        }
    }

    public ApacheAsyncClient(HttpAsyncClient client, Config config, PoolingNHttpClientConnectionManager manager, AsyncIdleConnectionMonitorThread monitor) {
        Objects.requireNonNull(client, "Client may not be null");
        this.config = config;
        this.client = client;
        this.syncMonitor = monitor;
        this.manager = manager;
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> request(HttpRequest request, final Function<RawResponse, HttpResponse<T>> transformer, final CompletableFuture<HttpResponse<T>> callback) {
        Objects.requireNonNull(callback);
        HttpRequestBase requestObj = new RequestPrep(request, true).prepare();
        this.client.execute((HttpUriRequest)requestObj, (FutureCallback)new FutureCallback<org.apache.http.HttpResponse>(){

            public void completed(org.apache.http.HttpResponse httpResponse) {
                callback.complete(transformer.apply(new ApacheResponse(httpResponse, ApacheAsyncClient.this.config)));
            }

            public void failed(Exception e) {
                callback.completeExceptionally(e);
            }

            public void cancelled() {
                callback.completeExceptionally(new UnirestException("canceled"));
            }
        });
        return callback;
    }

    @Override
    public boolean isRunning() {
        return Util.tryCast(this.client, CloseableHttpAsyncClient.class).map(CloseableHttpAsyncClient::isRunning).orElse(true);
    }

    public HttpAsyncClient getClient() {
        return this.client;
    }

    @Override
    public Stream<Exception> close() {
        return Util.collectExceptions(Util.tryCast(this.client, CloseableHttpAsyncClient.class).filter(c -> c.isRunning()).map(c -> Util.tryDo(c, d -> d.close())).filter(c -> c.isPresent()).map(c -> (Exception)c.get()), Util.tryDo(this.manager, m -> m.shutdown()), Util.tryDo(this.syncMonitor, m -> m.interrupt()));
    }
}

