/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core.json;

import java.io.Writer;
import java.util.Map;
import kong.unirest.core.json.CoreFactory;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JSONPointer;
import kong.unirest.core.json.JsonEngine;
import kong.unirest.core.json.ToObjectMapper;

public abstract class JSONElement {
    protected static final transient ToObjectMapper MAPPER = new ToObjectMapper();
    private static final transient JsonEngine ENGINE = CoreFactory.getCore();
    private final JsonEngine.Element element;

    protected JSONElement(JsonEngine.Element e) {
        this.element = e;
    }

    public Writer write(Writer sw) throws JSONException {
        JSONElement.write(this.element, sw);
        return sw;
    }

    public Writer write(Writer sw, int indentFactor, int indent) throws JSONException {
        ENGINE.toPrettyJson(this.element, sw);
        return sw;
    }

    public Object query(String query) {
        return this.query(JSONPointer.compile(query));
    }

    public Object query(JSONPointer query) {
        return query.queryFrom(this);
    }

    public Object optQuery(String query) {
        try {
            return this.query(query);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object optQuery(JSONPointer query) {
        try {
            return query.queryFrom(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JsonEngine.Element getElement() {
        return this.element;
    }

    static JsonEngine.Object toJsonObject(Map map) {
        return JSONElement.toTree(map).getAsJsonObject();
    }

    static String toJson(JsonEngine.Element collection) {
        return ENGINE.toJson(collection);
    }

    static JsonEngine.Element toTree(Object obj) {
        return ENGINE.toJsonTree(obj);
    }

    static void write(JsonEngine.Element obj, Writer sw) {
        ENGINE.toJson(obj, sw);
    }

    protected static String toPrettyJson(JsonEngine.Element obj) {
        return ENGINE.toPrettyJson(obj);
    }

    protected static Map<String, Object> toMap(JsonEngine.Element obj) {
        return ENGINE.fromJson(obj, Map.class);
    }
}

