/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.HashOverflowException;
import com.koloboke.collect.impl.ByteArrays;
import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.ParallelKVByteQHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.UpdatableQHash;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class UpdatableParallelKVByteQHashSO
extends UpdatableQHash
implements ParallelKVByteQHash,
PrimitiveConstants,
UnsafeConstants {
    byte freeValue;
    char[] table;

    void copy(ParallelKVByteQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = (char[])hash.table().clone();
    }

    void move(ParallelKVByteQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.table = hash.table();
    }

    final void init(HashConfigWrapper configWrapper, int size, byte freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public byte freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public byte removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains((Byte)key);
    }

    public boolean contains(byte key) {
        return this.index(key) >= 0;
    }

    int index(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (byte)(entry = tab[bIndex])) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (byte)(entry = tab[fIndex])) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 2;
            }
        }
        return -1;
    }

    private byte findNewFreeOrRemoved() {
        byte newFree;
        block6: {
            int mc = this.modCount();
            int size = this.size();
            if (size >= 255) {
                throw new HashOverflowException();
            }
            byte free = this.freeValue;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (size > 192) {
                int nf = ((Random)random).nextInt(256) * 97;
                for (int i = 0; i < 256; ++i) {
                    newFree = (byte)(nf += 97);
                    if (newFree == free || this.index(newFree) >= 0) {
                        continue;
                    }
                    break block6;
                }
                if (mc != this.modCount()) {
                    throw new ConcurrentModificationException();
                }
                throw new AssertionError((Object)"Impossible state");
            }
            while ((newFree = (byte)((Random)random).nextInt()) == free || this.index(newFree) >= 0) {
            }
        }
        return newFree;
    }

    byte changeFree() {
        int mc = this.modCount();
        byte newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ByteArrays.replaceAllKeys((char[])this.table, (byte)this.freeValue, (byte)newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new char[capacity];
        if (this.freeValue != 0) {
            ByteArrays.fillKeys((char[])this.table, (byte)this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        ByteArrays.fillKeys((char[])this.table, (byte)this.freeValue);
    }
}

