/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ByteCollection;
import com.koloboke.collect.ByteCursor;
import com.koloboke.collect.ByteIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractByteValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonLongByteMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalLongByteMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.SeparateKVLongByteLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashSeparateKVLongByteMapSO;
import com.koloboke.collect.map.LongByteCursor;
import com.koloboke.collect.set.ByteSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteBinaryOperator;
import com.koloboke.function.ByteConsumer;
import com.koloboke.function.BytePredicate;
import com.koloboke.function.LongByteConsumer;
import com.koloboke.function.LongBytePredicate;
import com.koloboke.function.LongByteToByteFunction;
import com.koloboke.function.LongToByteFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class UpdatableLHashSeparateKVLongByteMapGO
extends UpdatableLHashSeparateKVLongByteMapSO {
    @Override
    final void copy(SeparateKVLongByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVLongByteLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    public boolean containsEntry(long key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Byte get(Object key) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public byte get(long key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Byte getOrDefault(Object key, Byte defaultValue) {
        int index = this.index((Long)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public byte getOrDefault(long key, byte defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Long, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept((Long)key, (Byte)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(LongByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(LongBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public LongByteCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonLongByteMapOps.containsAllEntries((InternalLongByteMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalLongByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalLongByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Long, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            hashCode += (int)(key ^ key >>> 32) ^ vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        byte[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newKeys = this.set;
        int capacityMask = newKeys.length - 1;
        byte[] newVals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            int index = LHash.SeparateKVLongKeyMixing.mix((long)key) & capacityMask;
            if (newKeys[index] != free) {
                while (newKeys[index = index - 1 & capacityMask] != free) {
                }
            }
            newKeys[index] = key;
            newVals[index] = vals[i];
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Byte put(Long key, Byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        byte[] vals = this.values;
        byte prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public byte put(long key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        byte[] vals = this.values;
        byte prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public Byte putIfAbsent(Long key, Byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    public byte putIfAbsent(long key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    public void justPut(long key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    /*
     * Unable to fully structure code
     */
    public Byte compute(Long key, BiFunction<? super Long, ? super Byte, ? extends Byte> remappingFunction) {
        block5: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVLongKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl16
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl16:
                // 2 sources

                if ((newValue = remappingFunction.apply((Long)k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Long)k, (Byte)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public byte compute(long key, LongByteToByteFunction remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVLongKeyMixing.mix((long)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                newValue = remappingFunction.applyAsByte(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsByte(key, vals[index]);
        return newValue;
    }

    public Byte computeIfAbsent(Long key, Function<? super Long, ? extends Byte> mappingFunction) {
        Byte value;
        long k = key;
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        }
        long[] keys = this.set;
        byte[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVLongKeyMixing.mix((long)k) & capacityMask;
        long cur = keys[index];
        if (cur == k) {
            return vals[index];
        }
        if (cur != free) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != k) continue;
                return vals[index];
            } while (cur != free);
        }
        if ((value = mappingFunction.apply((Long)k)) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public byte computeIfAbsent(long key, LongToByteFunction mappingFunction) {
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        }
        long[] keys = this.set;
        byte[] vals = this.values;
        int capacityMask = keys.length - 1;
        int index = LHash.SeparateKVLongKeyMixing.mix((long)key) & capacityMask;
        long cur = keys[index];
        if (cur == key) {
            return vals[index];
        }
        if (cur != free) {
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return vals[index];
            } while (cur != free);
        }
        byte value = mappingFunction.applyAsByte(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = value;
        this.postInsertHook();
        return value;
    }

    public Byte computeIfPresent(Long key, BiFunction<? super Long, ? super Byte, ? extends Byte> remappingFunction) {
        long k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            byte[] vals = this.values;
            Byte newValue = remappingFunction.apply((Long)k, (Byte)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
        }
        return null;
    }

    public byte computeIfPresent(long key, LongByteToByteFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            byte newValue;
            byte[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsByte(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    /*
     * Unable to fully structure code
     */
    public Byte merge(Long key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        block5: {
            k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVLongKeyMixing.mix((long)k) & capacityMask;
            cur = keys[index];
            if (cur == k) break block5;
            if (cur == free) ** GOTO lbl18
            while ((cur = keys[index = index - 1 & capacityMask]) != k) {
                if (cur != free) continue;
lbl18:
                // 2 sources

                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public byte merge(long key, byte value, ByteBinaryOperator remappingFunction) {
        block3: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVLongKeyMixing.mix((long)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block3;
            if (cur == free) ** GOTO lbl15
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsByte(vals[index], value);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public byte addValue(long key, byte value) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVLongKeyMixing.mix((long)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl13:
                // 2 sources

                newValue = (byte)(this.defaultValue() + value);
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (byte)(vals[index] + value);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public byte addValue(long key, byte addition, byte initialValue) {
        block2: {
            free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            }
            keys = this.set;
            vals = this.values;
            capacityMask = keys.length - 1;
            index = LHash.SeparateKVLongKeyMixing.mix((long)key) & capacityMask;
            cur = keys[index];
            if (cur == key) break block2;
            if (cur == free) ** GOTO lbl13
            while ((cur = keys[index = index - 1 & capacityMask]) != key) {
                if (cur != free) continue;
lbl13:
                // 2 sources

                newValue = (byte)(initialValue + addition);
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (byte)(vals[index] + addition);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Long, ? extends Byte> m) {
        CommonLongByteMapOps.putAll((InternalLongByteMapOps)this, m);
    }

    public Byte replace(Long key, Byte value) {
        int index = this.index(key);
        if (index >= 0) {
            byte[] vals = this.values;
            byte oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    public byte replace(long key, byte value) {
        int index = this.index(key);
        if (index >= 0) {
            byte[] vals = this.values;
            byte oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Long key, Byte oldValue, Byte newValue) {
        return this.replace((long)key, (byte)oldValue, (byte)newValue);
    }

    public boolean replace(long key, byte oldValue, byte newValue) {
        int index = this.index(key);
        if (index >= 0) {
            byte[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Long, ? super Byte, ? extends Byte> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            vals[i] = function.apply((Long)key, (Byte)vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(LongByteToByteFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long free = this.freeValue;
        long[] keys = this.set;
        byte[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key == free) continue;
            vals[i] = function.applyAsByte(key, vals[i]);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Byte remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(long key) {
        throw new UnsupportedOperationException();
    }

    public byte remove(long key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, (Byte)value);
    }

    public boolean remove(long key, byte value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(LongBytePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements LongByteCursor {
        final long[] keys;
        final byte[] vals;
        final long free;
        int expectedModCount;
        int index;
        long curKey;
        byte curValue;

        NoRemovedMapCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            this.curKey = free = (this.free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue);
        }

        public void forEachForward(LongByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public long key() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final long[] keys;
        final byte[] vals;
        final long free;
        int expectedModCount;
        int index;
        long curKey;
        byte curValue;

        NoRemovedValueCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            this.curKey = free = (this.free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue);
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final long[] keys;
        final byte[] vals;
        final long free;
        int expectedModCount;
        int nextIndex;
        byte next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            this.vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            long free = this.free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            if (this.expectedModCount == UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    long[] keys = this.keys;
                    long free = this.free;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Byte)vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Long, Byte>> {
        final long[] keys;
        final byte[] vals;
        final long free;
        int expectedModCount;
        int index;
        long curKey;
        byte curValue;

        NoRemovedEntryCursor(int mc) {
            long free;
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            this.index = this.keys.length;
            this.vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            this.curKey = free = (this.free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Long, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            long free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Byte>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Long, Byte> elem() {
            long curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                long[] keys = this.keys;
                long free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    long key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Long, Byte>> {
        final long[] keys;
        final byte[] vals;
        final long free;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            this.vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            long free = this.free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Long, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] keys = this.keys;
            byte[] vals = this.vals;
            long free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Byte>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Long, Byte> next() {
            int mc = this.expectedModCount;
            if (mc == UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    long[] keys = this.keys;
                    long free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        public int size() {
            return UpdatableLHashSeparateKVLongByteMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableLHashSeparateKVLongByteMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return UpdatableLHashSeparateKVLongByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return UpdatableLHashSeparateKVLongByteMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Byte)vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeByte(vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ByteCursor cursor() {
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return UpdatableLHashSeparateKVLongByteMapGO.this.removeValue(v);
        }

        public void clear() {
            UpdatableLHashSeparateKVLongByteMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Byte> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(BytePredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends LongByteEntry {
        private long key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(long key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    class MutableEntry
    extends LongByteEntry {
        final int modCount;
        private final int index;
        final long key;
        private byte value;

        MutableEntry(int modCount, int index, long key, byte value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }

        public Byte setValue(Byte newValue) {
            byte unwrappedNewValue;
            if (this.modCount != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            byte oldValue = this.value;
            this.value = unwrappedNewValue = newValue.byteValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(byte newValue) {
            UpdatableLHashSeparateKVLongByteMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class LongByteEntry
    extends AbstractEntry<Long, Byte> {
        LongByteEntry() {
        }

        abstract long key();

        public final Long getKey() {
            return this.key();
        }

        abstract byte value();

        public final Byte getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                long k2 = (Long)e2.getKey();
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((long)this.key()) ^ Primitives.hashCode((byte)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Long, Byte>>
    implements HashObjSet<Map.Entry<Long, Byte>>,
    InternalObjCollectionOps<Map.Entry<Long, Byte>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Long, Byte>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableLHashSeparateKVLongByteMapGO.this.hashConfig();
        }

        public int size() {
            return UpdatableLHashSeparateKVLongByteMapGO.this.size;
        }

        public double currentLoad() {
            return UpdatableLHashSeparateKVLongByteMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableLHashSeparateKVLongByteMapGO.this.containsEntry((Long)e.getKey(), (Byte)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Long, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Long, Byte>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Long, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || predicate.test((Map.Entry<Long, Byte>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Long, Byte>> iterator() {
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Long, Byte>> cursor() {
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Long, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return UpdatableLHashSeparateKVLongByteMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashSeparateKVLongByteMapGO.this.modCount();
            long free = UpdatableLHashSeparateKVLongByteMapGO.this.freeValue;
            long[] keys = UpdatableLHashSeparateKVLongByteMapGO.this.set;
            byte[] vals = UpdatableLHashSeparateKVLongByteMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                long key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashSeparateKVLongByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableLHashSeparateKVLongByteMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                long key = (Long)e.getKey();
                byte value = (Byte)e.getValue();
                return UpdatableLHashSeparateKVLongByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Long, Byte>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            UpdatableLHashSeparateKVLongByteMapGO.this.doClear();
        }
    }
}

