/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.CharHashFactory;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.hash.HashContainerFactory;
import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.hash.ImmutableQHashCharSetGO;
import com.koloboke.collect.impl.hash.LHashCapacities;
import com.koloboke.collect.impl.hash.MutableQHashCharSetGO;
import com.koloboke.collect.impl.hash.QHashCharSetFactorySO;
import com.koloboke.collect.impl.hash.SeparateKVCharQHash;
import com.koloboke.collect.impl.hash.UpdatableQHashCharSetGO;
import com.koloboke.collect.set.hash.HashCharSet;
import com.koloboke.collect.set.hash.HashCharSetFactory;
import com.koloboke.function.CharConsumer;
import com.koloboke.function.Predicate;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public abstract class QHashCharSetFactoryGO
extends QHashCharSetFactorySO {
    public QHashCharSetFactoryGO(HashConfig hashConf, int defaultExpectedSize, char lower, char upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    abstract HashCharSetFactory thisWith(HashConfig var1, int var2, char var3, char var4);

    abstract HashCharSetFactory lHashLikeThisWith(HashConfig var1, int var2, char var3, char var4);

    abstract HashCharSetFactory qHashLikeThisWith(HashConfig var1, int var2, char var3, char var4);

    public final HashCharSetFactory withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash((HashConfig)hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public final HashCharSetFactory withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.getLowerKeyDomainBound(), this.getUpperKeyDomainBound());
    }

    public String toString() {
        return "HashCharSetFactory[" + this.commonString() + this.keySpecialString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashCharSetFactory) {
            HashCharSetFactory factory = (HashCharSetFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals((CharHashFactory)factory);
        }
        return false;
    }

    public int hashCode() {
        return this.keySpecialHashCode(this.commonHashCode());
    }

    private UpdatableQHashCharSetGO shrunk(UpdatableQHashCharSetGO set) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(set)) {
            set.shrink();
        }
        return set;
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet() {
        return this.newUpdatableSet(this.getDefaultExpectedSize());
    }

    @Nonnull
    public MutableQHashCharSetGO newMutableSet() {
        return this.newMutableSet(this.getDefaultExpectedSize());
    }

    private static int sizeOr(Iterable elems, int defaultSize) {
        return elems instanceof Collection ? ((Collection)elems).size() : defaultSize;
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterable<Character> elements) {
        return this.newUpdatableSet((Iterable)elements, QHashCharSetFactoryGO.sizeOr(elements, this.getDefaultExpectedSize()));
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2) {
        long expectedSize = QHashCharSetFactoryGO.sizeOr(elems1, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, Containers.sizeAsInt((long)(expectedSize += (long)QHashCharSetFactoryGO.sizeOr(elems2, 0))));
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3) {
        long expectedSize = QHashCharSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashCharSetFactoryGO.sizeOr(elems2, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, Containers.sizeAsInt((long)(expectedSize += (long)QHashCharSetFactoryGO.sizeOr(elems3, 0))));
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4) {
        long expectedSize = QHashCharSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashCharSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)QHashCharSetFactoryGO.sizeOr(elems3, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, Containers.sizeAsInt((long)(expectedSize += (long)QHashCharSetFactoryGO.sizeOr(elems4, 0))));
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, Iterable<Character> elems5) {
        long expectedSize = QHashCharSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)QHashCharSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)QHashCharSetFactoryGO.sizeOr(elems3, 0);
        expectedSize += (long)QHashCharSetFactoryGO.sizeOr(elems4, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, Containers.sizeAsInt((long)(expectedSize += (long)QHashCharSetFactoryGO.sizeOr(elems5, 0))));
    }

    @Override
    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterable<Character> elements, int expectedSize) {
        return this.shrunk((UpdatableQHashCharSetGO)super.newUpdatableSet((Iterable)elements, expectedSize));
    }

    private static void addAll(UpdatableQHashCharSetGO set, Iterable<? extends Character> elems) {
        if (elems instanceof Collection) {
            set.addAll((Collection)elems);
        } else {
            Iterator<? extends Character> iterator = elems.iterator();
            while (iterator.hasNext()) {
                char e = iterator.next().charValue();
                set.add(e);
            }
        }
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, int expectedSize) {
        UpdatableQHashCharSetGO set = this.newUpdatableSet(expectedSize);
        QHashCharSetFactoryGO.addAll(set, elems1);
        QHashCharSetFactoryGO.addAll(set, elems2);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, int expectedSize) {
        UpdatableQHashCharSetGO set = this.newUpdatableSet(expectedSize);
        QHashCharSetFactoryGO.addAll(set, elems1);
        QHashCharSetFactoryGO.addAll(set, elems2);
        QHashCharSetFactoryGO.addAll(set, elems3);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, int expectedSize) {
        UpdatableQHashCharSetGO set = this.newUpdatableSet(expectedSize);
        QHashCharSetFactoryGO.addAll(set, elems1);
        QHashCharSetFactoryGO.addAll(set, elems2);
        QHashCharSetFactoryGO.addAll(set, elems3);
        QHashCharSetFactoryGO.addAll(set, elems4);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, Iterable<Character> elems5, int expectedSize) {
        UpdatableQHashCharSetGO set = this.newUpdatableSet(expectedSize);
        QHashCharSetFactoryGO.addAll(set, elems1);
        QHashCharSetFactoryGO.addAll(set, elems2);
        QHashCharSetFactoryGO.addAll(set, elems3);
        QHashCharSetFactoryGO.addAll(set, elems4);
        QHashCharSetFactoryGO.addAll(set, elems5);
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterator<Character> elements) {
        return this.newUpdatableSet((Iterator)elements, this.getDefaultExpectedSize());
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Iterator<Character> elements, int expectedSize) {
        UpdatableQHashCharSetGO set = this.newUpdatableSet(expectedSize);
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Consumer<CharConsumer> elementsSupplier) {
        return this.newUpdatableSet((Consumer)elementsSupplier, this.getDefaultExpectedSize());
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Consumer<CharConsumer> elementsSupplier, int expectedSize) {
        final UpdatableQHashCharSetGO set = this.newUpdatableSet(expectedSize);
        elementsSupplier.accept(new CharConsumer(){

            public void accept(char e) {
                set.add(e);
            }
        });
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(char[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(char[] elements, int expectedSize) {
        UpdatableQHashCharSetGO set = this.newUpdatableSet(expectedSize);
        for (char e : elements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Character[] elements) {
        return this.newUpdatableSet(elements, elements.length);
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSet(Character[] elements, int expectedSize) {
        UpdatableQHashCharSetGO set = this.newUpdatableSet(expectedSize);
        Character[] characterArray = elements;
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char e = characterArray[i].charValue();
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSetOf(char e1) {
        UpdatableQHashCharSetGO set = this.newUpdatableSet(1);
        set.add(e1);
        return set;
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSetOf(char e1, char e2) {
        UpdatableQHashCharSetGO set = this.newUpdatableSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSetOf(char e1, char e2, char e3) {
        UpdatableQHashCharSetGO set = this.newUpdatableSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSetOf(char e1, char e2, char e3, char e4) {
        UpdatableQHashCharSetGO set = this.newUpdatableSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    @Nonnull
    public UpdatableQHashCharSetGO newUpdatableSetOf(char e1, char e2, char e3, char e4, char e5, char ... restElements) {
        UpdatableQHashCharSetGO set = this.newUpdatableSet(5 + restElements.length);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        for (char e : restElements) {
            set.add(e);
        }
        return this.shrunk(set);
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elements, int expectedSize) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, int expectedSize) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, int expectedSize) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, int expectedSize) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, Iterable<Character> elems5, int expectedSize) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elements) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, Iterable<Character> elems5) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterator<Character> elements) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Iterator<Character> elements, int expectedSize) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Consumer<CharConsumer> elementsSupplier) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Consumer<CharConsumer> elementsSupplier, int expectedSize) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(char[] elements) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(char[] elements, int expectedSize) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Character[] elements) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSet(Character[] elements, int expectedSize) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSetOf(char e1) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSetOf(char e1, char e2) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSetOf(char e1, char e2, char e3) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSetOf(char e1, char e2, char e3, char e4) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    @Nonnull
    public HashCharSet newMutableSetOf(char e1, char e2, char e3, char e4, char e5, char ... restElements) {
        MutableQHashCharSetGO set = this.uninitializedMutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elements, int expectedSize) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, int expectedSize) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, int expectedSize) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, int expectedSize) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, Iterable<Character> elems5, int expectedSize) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elements) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterable<Character> elems1, Iterable<Character> elems2, Iterable<Character> elems3, Iterable<Character> elems4, Iterable<Character> elems5) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterator<Character> elements) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Iterator<Character> elements, int expectedSize) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Consumer<CharConsumer> elementsSupplier) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Consumer<CharConsumer> elementsSupplier, int expectedSize) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVCharQHash)this.newUpdatableSet((Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(char[] elements) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(char[] elements, int expectedSize) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Character[] elements) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSet(Character[] elements, int expectedSize) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSet(elements, expectedSize));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSetOf(char e1) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSetOf(char e1, char e2) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSetOf(char e1, char e2, char e3) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSetOf(char e1, char e2, char e3, char e4) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4));
        return set;
    }

    @Nonnull
    public HashCharSet newImmutableSetOf(char e1, char e2, char e3, char e4, char e5, char ... restElements) {
        ImmutableQHashCharSetGO set = this.uninitializedImmutableSet();
        set.move(this.newUpdatableSetOf(e1, e2, e3, e4, e5, restElements));
        return set;
    }
}

